/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.apache.hc.core5.http.protocol;

import com.databricks.internal.apache.hc.core5.annotation.Contract;
import com.databricks.internal.apache.hc.core5.annotation.ThreadingBehavior;
import com.databricks.internal.apache.hc.core5.http.EntityDetails;
import com.databricks.internal.apache.hc.core5.http.HttpException;
import com.databricks.internal.apache.hc.core5.http.HttpResponse;
import com.databricks.internal.apache.hc.core5.http.HttpResponseInterceptor;
import com.databricks.internal.apache.hc.core5.http.protocol.HttpContext;
import com.databricks.internal.apache.hc.core5.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class ResponseServer
implements HttpResponseInterceptor {
    private final String originServer;

    public ResponseServer(String originServer) {
        this.originServer = originServer;
    }

    public ResponseServer() {
        this(null);
    }

    @Override
    public void process(HttpResponse response, EntityDetails entity, HttpContext context) throws HttpException, IOException {
        Args.notNull(response, "HTTP response");
        if (!response.containsHeader("Server") && this.originServer != null) {
            response.addHeader("Server", this.originServer);
        }
    }
}

