/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.bouncycastle.cms;

import com.databricks.internal.bouncycastle.asn1.ASN1OctetString;
import com.databricks.internal.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import com.databricks.internal.bouncycastle.asn1.cms.KEMRecipientInfo;
import com.databricks.internal.bouncycastle.asn1.cms.RecipientIdentifier;
import com.databricks.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.databricks.internal.bouncycastle.cms.CMSException;
import com.databricks.internal.bouncycastle.cms.CMSSecureReadable;
import com.databricks.internal.bouncycastle.cms.KEMRecipient;
import com.databricks.internal.bouncycastle.cms.KeyTransRecipientId;
import com.databricks.internal.bouncycastle.cms.Recipient;
import com.databricks.internal.bouncycastle.cms.RecipientInformation;
import com.databricks.internal.bouncycastle.cms.RecipientOperator;

public class KEMRecipientInformation
extends RecipientInformation {
    private KEMRecipientInfo info;

    KEMRecipientInformation(KEMRecipientInfo kEMRecipientInfo, AlgorithmIdentifier algorithmIdentifier, CMSSecureReadable cMSSecureReadable) {
        super(kEMRecipientInfo.getKem(), algorithmIdentifier, cMSSecureReadable);
        this.info = kEMRecipientInfo;
        RecipientIdentifier recipientIdentifier = kEMRecipientInfo.getRecipientIdentifier();
        if (recipientIdentifier.isTagged()) {
            ASN1OctetString aSN1OctetString = ASN1OctetString.getInstance(recipientIdentifier.getId());
            this.rid = new KeyTransRecipientId(aSN1OctetString.getOctets());
        } else {
            IssuerAndSerialNumber issuerAndSerialNumber = IssuerAndSerialNumber.getInstance(recipientIdentifier.getId());
            this.rid = new KeyTransRecipientId(issuerAndSerialNumber.getName(), issuerAndSerialNumber.getSerialNumber().getValue());
        }
    }

    @Override
    protected RecipientOperator getRecipientOperator(Recipient recipient) throws CMSException {
        return ((KEMRecipient)recipient).getRecipientOperator(new AlgorithmIdentifier(this.keyEncAlg.getAlgorithm(), this.info), this.messageAlgorithm, this.info.getEncryptedKey().getOctets());
    }
}

