/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.bouncycastle.crypto.generators;

import com.databricks.internal.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.databricks.internal.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import com.databricks.internal.bouncycastle.crypto.CryptoServicePurpose;
import com.databricks.internal.bouncycastle.crypto.CryptoServicesRegistrar;
import com.databricks.internal.bouncycastle.crypto.KeyGenerationParameters;
import com.databricks.internal.bouncycastle.crypto.constraints.DefaultServiceProperties;
import com.databricks.internal.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import com.databricks.internal.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import java.security.SecureRandom;

public class Ed25519KeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private SecureRandom random;

    @Override
    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.random = keyGenerationParameters.getRandom();
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties("Ed25519KeyGen", 128, null, CryptoServicePurpose.KEYGEN));
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        Ed25519PrivateKeyParameters ed25519PrivateKeyParameters = new Ed25519PrivateKeyParameters(this.random);
        Ed25519PublicKeyParameters ed25519PublicKeyParameters = ed25519PrivateKeyParameters.generatePublicKey();
        return new AsymmetricCipherKeyPair(ed25519PublicKeyParameters, ed25519PrivateKeyParameters);
    }
}

