/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.bouncycastle.pqc.crypto.crystals.kyber;

import com.databricks.internal.bouncycastle.crypto.EncapsulatedSecretGenerator;
import com.databricks.internal.bouncycastle.crypto.SecretWithEncapsulation;
import com.databricks.internal.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.databricks.internal.bouncycastle.pqc.crypto.crystals.kyber.KyberEngine;
import com.databricks.internal.bouncycastle.pqc.crypto.crystals.kyber.KyberPublicKeyParameters;
import com.databricks.internal.bouncycastle.pqc.crypto.util.SecretWithEncapsulationImpl;
import java.security.SecureRandom;

public class KyberKEMGenerator
implements EncapsulatedSecretGenerator {
    private final SecureRandom sr;

    public KyberKEMGenerator(SecureRandom secureRandom) {
        this.sr = secureRandom;
    }

    @Override
    public SecretWithEncapsulation generateEncapsulated(AsymmetricKeyParameter asymmetricKeyParameter) {
        KyberPublicKeyParameters kyberPublicKeyParameters = (KyberPublicKeyParameters)asymmetricKeyParameter;
        KyberEngine kyberEngine = kyberPublicKeyParameters.getParameters().getEngine();
        kyberEngine.init(this.sr);
        byte[][] byArray = kyberEngine.kemEncrypt(kyberPublicKeyParameters.getEncoded());
        return new SecretWithEncapsulationImpl(byArray[0], byArray[1]);
    }
}

