/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.bouncycastle.pqc.crypto.xwing;

import com.databricks.internal.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.databricks.internal.bouncycastle.crypto.EncapsulatedSecretGenerator;
import com.databricks.internal.bouncycastle.crypto.SecretWithEncapsulation;
import com.databricks.internal.bouncycastle.crypto.agreement.X25519Agreement;
import com.databricks.internal.bouncycastle.crypto.digests.SHA3Digest;
import com.databricks.internal.bouncycastle.crypto.generators.X25519KeyPairGenerator;
import com.databricks.internal.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.databricks.internal.bouncycastle.crypto.params.X25519KeyGenerationParameters;
import com.databricks.internal.bouncycastle.crypto.params.X25519PublicKeyParameters;
import com.databricks.internal.bouncycastle.pqc.crypto.crystals.kyber.KyberKEMGenerator;
import com.databricks.internal.bouncycastle.pqc.crypto.util.SecretWithEncapsulationImpl;
import com.databricks.internal.bouncycastle.pqc.crypto.xwing.XWingPublicKeyParameters;
import com.databricks.internal.bouncycastle.util.Arrays;
import com.databricks.internal.bouncycastle.util.Strings;
import java.security.SecureRandom;

public class XWingKEMGenerator
implements EncapsulatedSecretGenerator {
    private final SecureRandom sr;

    public XWingKEMGenerator(SecureRandom secureRandom) {
        this.sr = secureRandom;
    }

    @Override
    public SecretWithEncapsulation generateEncapsulated(AsymmetricKeyParameter asymmetricKeyParameter) {
        XWingPublicKeyParameters xWingPublicKeyParameters = (XWingPublicKeyParameters)asymmetricKeyParameter;
        KyberKEMGenerator kyberKEMGenerator = new KyberKEMGenerator(this.sr);
        SecretWithEncapsulation secretWithEncapsulation = kyberKEMGenerator.generateEncapsulated(xWingPublicKeyParameters.getKyberPublicKey());
        X25519Agreement x25519Agreement = new X25519Agreement();
        byte[] byArray = secretWithEncapsulation.getSecret();
        byte[] byArray2 = new byte[byArray.length + x25519Agreement.getAgreementSize()];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        Arrays.clear(byArray);
        X25519KeyPairGenerator x25519KeyPairGenerator = new X25519KeyPairGenerator();
        x25519KeyPairGenerator.init(new X25519KeyGenerationParameters(this.sr));
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = x25519KeyPairGenerator.generateKeyPair();
        x25519Agreement.init(asymmetricCipherKeyPair.getPrivate());
        x25519Agreement.calculateAgreement(xWingPublicKeyParameters.getXDHPublicKey(), byArray2, byArray.length);
        X25519PublicKeyParameters x25519PublicKeyParameters = (X25519PublicKeyParameters)asymmetricCipherKeyPair.getPublic();
        SHA3Digest sHA3Digest = new SHA3Digest(256);
        sHA3Digest.update(Strings.toByteArray("\\.//^\\"), 0, 6);
        sHA3Digest.update(byArray2, 0, byArray2.length);
        sHA3Digest.update(x25519PublicKeyParameters.getEncoded(), 0, 32);
        sHA3Digest.update(xWingPublicKeyParameters.getXDHPublicKey().getEncoded(), 0, 32);
        byte[] byArray3 = new byte[32];
        sHA3Digest.doFinal(byArray3, 0);
        return new SecretWithEncapsulationImpl(byArray3, Arrays.concatenate(secretWithEncapsulation.getEncapsulation(), x25519PublicKeyParameters.getEncoded()));
    }
}

