/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.bouncycastle.tsp.cms;

import com.databricks.internal.bouncycastle.asn1.BEROctetString;
import com.databricks.internal.bouncycastle.asn1.DERIA5String;
import com.databricks.internal.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import com.databricks.internal.bouncycastle.asn1.cms.ContentInfo;
import com.databricks.internal.bouncycastle.asn1.cms.Evidence;
import com.databricks.internal.bouncycastle.asn1.cms.TimeStampAndCRL;
import com.databricks.internal.bouncycastle.asn1.cms.TimeStampTokenEvidence;
import com.databricks.internal.bouncycastle.asn1.cms.TimeStampedData;
import com.databricks.internal.bouncycastle.cms.CMSException;
import com.databricks.internal.bouncycastle.tsp.TimeStampToken;
import com.databricks.internal.bouncycastle.tsp.cms.CMSTimeStampedData;
import com.databricks.internal.bouncycastle.tsp.cms.CMSTimeStampedGenerator;
import com.databricks.internal.bouncycastle.util.io.Streams;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class CMSTimeStampedDataGenerator
extends CMSTimeStampedGenerator {
    public CMSTimeStampedData generate(TimeStampToken timeStampToken) throws CMSException {
        return this.generate(timeStampToken, (InputStream)null);
    }

    public CMSTimeStampedData generate(TimeStampToken timeStampToken, byte[] byArray) throws CMSException {
        return this.generate(timeStampToken, new ByteArrayInputStream(byArray));
    }

    public CMSTimeStampedData generate(TimeStampToken timeStampToken, InputStream inputStream) throws CMSException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (inputStream != null) {
            try {
                Streams.pipeAll(inputStream, byteArrayOutputStream);
            }
            catch (IOException iOException) {
                throw new CMSException("exception encapsulating content: " + iOException.getMessage(), iOException);
            }
        }
        BEROctetString bEROctetString = null;
        if (byteArrayOutputStream.size() != 0) {
            bEROctetString = new BEROctetString(byteArrayOutputStream.toByteArray());
        }
        TimeStampAndCRL timeStampAndCRL = new TimeStampAndCRL(timeStampToken.toCMSSignedData().toASN1Structure());
        DERIA5String dERIA5String = null;
        if (this.dataUri != null) {
            dERIA5String = new DERIA5String(this.dataUri.toString());
        }
        return new CMSTimeStampedData(new ContentInfo(CMSObjectIdentifiers.timestampedData, new TimeStampedData(dERIA5String, this.metaData, bEROctetString, new Evidence(new TimeStampTokenEvidence(timeStampAndCRL)))));
    }
}

