/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.core.oauth;

import com.databricks.internal.fasterxml.jackson.databind.ObjectMapper;
import com.databricks.internal.sdk.core.CredentialsProvider;
import com.databricks.internal.sdk.core.DatabricksConfig;
import com.databricks.internal.sdk.core.oauth.AuthParameterPosition;
import com.databricks.internal.sdk.core.oauth.ClientCredentials;
import com.databricks.internal.sdk.core.oauth.OAuthHeaderFactory;
import com.databricks.internal.sdk.core.oauth.RefreshableTokenSource;
import com.databricks.internal.sdk.core.utils.AzureUtils;
import java.util.HashMap;

public class AzureServicePrincipalCredentialsProvider
implements CredentialsProvider {
    private final ObjectMapper mapper = new ObjectMapper();

    @Override
    public String authType() {
        return "azure-client-secret";
    }

    @Override
    public OAuthHeaderFactory configure(DatabricksConfig config) {
        if (!config.isAzure() || config.getAzureClientId() == null || config.getAzureClientSecret() == null || config.getAzureTenantId() == null) {
            return null;
        }
        AzureUtils.ensureHostPresent(config, this.mapper, AzureServicePrincipalCredentialsProvider::tokenSourceFor);
        RefreshableTokenSource inner = AzureServicePrincipalCredentialsProvider.tokenSourceFor(config, config.getEffectiveAzureLoginAppId());
        RefreshableTokenSource cloud = AzureServicePrincipalCredentialsProvider.tokenSourceFor(config, config.getAzureEnvironment().getServiceManagementEndpoint());
        return OAuthHeaderFactory.fromSuppliers(inner::getToken, () -> {
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Authorization", "Bearer " + inner.getToken().getAccessToken());
            AzureUtils.addWorkspaceResourceId(config, headers);
            AzureUtils.addSpManagementToken(cloud, headers);
            return headers;
        });
    }

    private static RefreshableTokenSource tokenSourceFor(DatabricksConfig config, String resource) {
        String aadEndpoint = config.getAzureEnvironment().getActiveDirectoryEndpoint();
        String tokenUrl = aadEndpoint + config.getAzureTenantId() + "/oauth2/token";
        HashMap<String, String> endpointParams = new HashMap<String, String>();
        endpointParams.put("resource", resource);
        return new ClientCredentials.Builder().withHttpClient(config.getHttpClient()).withClientId(config.getAzureClientId()).withClientSecret(config.getAzureClientSecret()).withTokenUrl(tokenUrl).withEndpointParametersSupplier(() -> endpointParams).withAuthParameterPosition(AuthParameterPosition.BODY).build();
    }
}

