/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.core.oauth;

import com.databricks.internal.google.common.collect.ImmutableMap;
import com.databricks.internal.sdk.core.CredentialsProvider;
import com.databricks.internal.sdk.core.DatabricksConfig;
import com.databricks.internal.sdk.core.DatabricksException;
import com.databricks.internal.sdk.core.HeaderFactory;
import com.databricks.internal.sdk.core.oauth.AuthParameterPosition;
import com.databricks.internal.sdk.core.oauth.ClientCredentials;
import com.databricks.internal.sdk.core.oauth.GitHubOidcTokenSupplier;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;

public class GithubOidcCredentialsProvider
implements CredentialsProvider {
    @Override
    public String authType() {
        return "github-oidc";
    }

    @Override
    public HeaderFactory configure(DatabricksConfig config) throws DatabricksException {
        String endpointUrl;
        GitHubOidcTokenSupplier idTokenProvider = new GitHubOidcTokenSupplier(config.getHttpClient(), config.getActionsIdTokenRequestUrl(), config.getActionsIdTokenRequestToken(), config.getTokenAudience());
        if (!idTokenProvider.enabled().booleanValue() || config.getHost() == null || config.getClientId() == null) {
            return null;
        }
        try {
            endpointUrl = config.getOidcEndpoints().getTokenEndpoint();
        }
        catch (IOException e) {
            throw new DatabricksException("Unable to fetch OIDC endpoint: " + e.getMessage(), e);
        }
        ClientCredentials clientCredentials = new ClientCredentials.Builder().withHttpClient(config.getHttpClient()).withClientId(config.getClientId()).withTokenUrl(endpointUrl).withScopes(Collections.singletonList("all-apis")).withAuthParameterPosition(AuthParameterPosition.HEADER).withEndpointParametersSupplier(() -> new ImmutableMap.Builder<String, String>().put("subject_token_type", "urn:ietf:params:oauth:token-type:jwt").put("subject_token", idTokenProvider.getOidcToken()).put("grant_type", "urn:ietf:params:oauth:grant-type:token-exchange").build()).build();
        return () -> {
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Authorization", "Bearer " + clientCredentials.getToken().getAccessToken());
            return headers;
        };
    }
}

