/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.catalog;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.core.DatabricksException;
import com.databricks.internal.sdk.core.http.Request;
import com.databricks.internal.sdk.service.catalog.EffectivePermissionsList;
import com.databricks.internal.sdk.service.catalog.GetEffectiveRequest;
import com.databricks.internal.sdk.service.catalog.GetGrantRequest;
import com.databricks.internal.sdk.service.catalog.GrantsService;
import com.databricks.internal.sdk.service.catalog.PermissionsList;
import com.databricks.internal.sdk.service.catalog.UpdatePermissions;
import com.databricks.internal.sdk.support.Generated;
import java.io.IOException;

@Generated
class GrantsImpl
implements GrantsService {
    private final ApiClient apiClient;

    public GrantsImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public PermissionsList get(GetGrantRequest request) {
        String path = String.format("/api/2.1/unity-catalog/permissions/%s/%s", new Object[]{request.getSecurableType(), request.getFullName()});
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, PermissionsList.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public EffectivePermissionsList getEffective(GetEffectiveRequest request) {
        String path = String.format("/api/2.1/unity-catalog/effective-permissions/%s/%s", new Object[]{request.getSecurableType(), request.getFullName()});
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, EffectivePermissionsList.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public PermissionsList update(UpdatePermissions request) {
        String path = String.format("/api/2.1/unity-catalog/permissions/%s/%s", new Object[]{request.getSecurableType(), request.getFullName()});
        try {
            Request req = new Request("PATCH", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, PermissionsList.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

