/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.compute;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.service.compute.ClusterPoliciesImpl;
import com.databricks.internal.sdk.service.compute.ClusterPoliciesService;
import com.databricks.internal.sdk.service.compute.ClusterPolicyPermissions;
import com.databricks.internal.sdk.service.compute.ClusterPolicyPermissionsRequest;
import com.databricks.internal.sdk.service.compute.CreatePolicy;
import com.databricks.internal.sdk.service.compute.CreatePolicyResponse;
import com.databricks.internal.sdk.service.compute.DeletePolicy;
import com.databricks.internal.sdk.service.compute.EditPolicy;
import com.databricks.internal.sdk.service.compute.GetClusterPolicyPermissionLevelsRequest;
import com.databricks.internal.sdk.service.compute.GetClusterPolicyPermissionLevelsResponse;
import com.databricks.internal.sdk.service.compute.GetClusterPolicyPermissionsRequest;
import com.databricks.internal.sdk.service.compute.GetClusterPolicyRequest;
import com.databricks.internal.sdk.service.compute.ListClusterPoliciesRequest;
import com.databricks.internal.sdk.service.compute.ListPoliciesResponse;
import com.databricks.internal.sdk.service.compute.Policy;
import com.databricks.internal.sdk.support.Generated;
import com.databricks.internal.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class ClusterPoliciesAPI {
    private static final Logger LOG = LoggerFactory.getLogger(ClusterPoliciesAPI.class);
    private final ClusterPoliciesService impl;

    public ClusterPoliciesAPI(ApiClient apiClient) {
        this.impl = new ClusterPoliciesImpl(apiClient);
    }

    public ClusterPoliciesAPI(ClusterPoliciesService mock) {
        this.impl = mock;
    }

    public CreatePolicyResponse create(CreatePolicy request) {
        return this.impl.create(request);
    }

    public void delete(String policyId) {
        this.delete(new DeletePolicy().setPolicyId(policyId));
    }

    public void delete(DeletePolicy request) {
        this.impl.delete(request);
    }

    public void edit(String policyId) {
        this.edit(new EditPolicy().setPolicyId(policyId));
    }

    public void edit(EditPolicy request) {
        this.impl.edit(request);
    }

    public Policy get(String policyId) {
        return this.get(new GetClusterPolicyRequest().setPolicyId(policyId));
    }

    public Policy get(GetClusterPolicyRequest request) {
        return this.impl.get(request);
    }

    public GetClusterPolicyPermissionLevelsResponse getPermissionLevels(String clusterPolicyId) {
        return this.getPermissionLevels(new GetClusterPolicyPermissionLevelsRequest().setClusterPolicyId(clusterPolicyId));
    }

    public GetClusterPolicyPermissionLevelsResponse getPermissionLevels(GetClusterPolicyPermissionLevelsRequest request) {
        return this.impl.getPermissionLevels(request);
    }

    public ClusterPolicyPermissions getPermissions(String clusterPolicyId) {
        return this.getPermissions(new GetClusterPolicyPermissionsRequest().setClusterPolicyId(clusterPolicyId));
    }

    public ClusterPolicyPermissions getPermissions(GetClusterPolicyPermissionsRequest request) {
        return this.impl.getPermissions(request);
    }

    public Iterable<Policy> list(ListClusterPoliciesRequest request) {
        return new Paginator(request, this.impl::list, ListPoliciesResponse::getPolicies, response -> null);
    }

    public ClusterPolicyPermissions setPermissions(String clusterPolicyId) {
        return this.setPermissions(new ClusterPolicyPermissionsRequest().setClusterPolicyId(clusterPolicyId));
    }

    public ClusterPolicyPermissions setPermissions(ClusterPolicyPermissionsRequest request) {
        return this.impl.setPermissions(request);
    }

    public ClusterPolicyPermissions updatePermissions(String clusterPolicyId) {
        return this.updatePermissions(new ClusterPolicyPermissionsRequest().setClusterPolicyId(clusterPolicyId));
    }

    public ClusterPolicyPermissions updatePermissions(ClusterPolicyPermissionsRequest request) {
        return this.impl.updatePermissions(request);
    }

    public ClusterPoliciesService impl() {
        return this.impl;
    }
}

