/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.compute;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.core.DatabricksException;
import com.databricks.internal.sdk.core.http.Request;
import com.databricks.internal.sdk.service.compute.ClusterPoliciesService;
import com.databricks.internal.sdk.service.compute.ClusterPolicyPermissions;
import com.databricks.internal.sdk.service.compute.ClusterPolicyPermissionsRequest;
import com.databricks.internal.sdk.service.compute.CreatePolicy;
import com.databricks.internal.sdk.service.compute.CreatePolicyResponse;
import com.databricks.internal.sdk.service.compute.DeletePolicy;
import com.databricks.internal.sdk.service.compute.DeletePolicyResponse;
import com.databricks.internal.sdk.service.compute.EditPolicy;
import com.databricks.internal.sdk.service.compute.EditPolicyResponse;
import com.databricks.internal.sdk.service.compute.GetClusterPolicyPermissionLevelsRequest;
import com.databricks.internal.sdk.service.compute.GetClusterPolicyPermissionLevelsResponse;
import com.databricks.internal.sdk.service.compute.GetClusterPolicyPermissionsRequest;
import com.databricks.internal.sdk.service.compute.GetClusterPolicyRequest;
import com.databricks.internal.sdk.service.compute.ListClusterPoliciesRequest;
import com.databricks.internal.sdk.service.compute.ListPoliciesResponse;
import com.databricks.internal.sdk.service.compute.Policy;
import com.databricks.internal.sdk.support.Generated;
import java.io.IOException;

@Generated
class ClusterPoliciesImpl
implements ClusterPoliciesService {
    private final ApiClient apiClient;

    public ClusterPoliciesImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public CreatePolicyResponse create(CreatePolicy request) {
        String path = "/api/2.0/policies/clusters/create";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, CreatePolicyResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void delete(DeletePolicy request) {
        String path = "/api/2.0/policies/clusters/delete";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            this.apiClient.execute(req, DeletePolicyResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void edit(EditPolicy request) {
        String path = "/api/2.0/policies/clusters/edit";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            this.apiClient.execute(req, EditPolicyResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public Policy get(GetClusterPolicyRequest request) {
        String path = "/api/2.0/policies/clusters/get";
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, Policy.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public GetClusterPolicyPermissionLevelsResponse getPermissionLevels(GetClusterPolicyPermissionLevelsRequest request) {
        String path = String.format("/api/2.0/permissions/cluster-policies/%s/permissionLevels", request.getClusterPolicyId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, GetClusterPolicyPermissionLevelsResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ClusterPolicyPermissions getPermissions(GetClusterPolicyPermissionsRequest request) {
        String path = String.format("/api/2.0/permissions/cluster-policies/%s", request.getClusterPolicyId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ClusterPolicyPermissions.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListPoliciesResponse list(ListClusterPoliciesRequest request) {
        String path = "/api/2.0/policies/clusters/list";
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListPoliciesResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ClusterPolicyPermissions setPermissions(ClusterPolicyPermissionsRequest request) {
        String path = String.format("/api/2.0/permissions/cluster-policies/%s", request.getClusterPolicyId());
        try {
            Request req = new Request("PUT", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, ClusterPolicyPermissions.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ClusterPolicyPermissions updatePermissions(ClusterPolicyPermissionsRequest request) {
        String path = String.format("/api/2.0/permissions/cluster-policies/%s", request.getClusterPolicyId());
        try {
            Request req = new Request("PATCH", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, ClusterPolicyPermissions.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

