/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.iam;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.core.DatabricksException;
import com.databricks.internal.sdk.core.http.Request;
import com.databricks.internal.sdk.service.iam.AccountServicePrincipalsService;
import com.databricks.internal.sdk.service.iam.DeleteAccountServicePrincipalRequest;
import com.databricks.internal.sdk.service.iam.DeleteResponse;
import com.databricks.internal.sdk.service.iam.GetAccountServicePrincipalRequest;
import com.databricks.internal.sdk.service.iam.ListAccountServicePrincipalsRequest;
import com.databricks.internal.sdk.service.iam.ListServicePrincipalResponse;
import com.databricks.internal.sdk.service.iam.PartialUpdate;
import com.databricks.internal.sdk.service.iam.PatchResponse;
import com.databricks.internal.sdk.service.iam.ServicePrincipal;
import com.databricks.internal.sdk.service.iam.UpdateResponse;
import com.databricks.internal.sdk.support.Generated;
import java.io.IOException;

@Generated
class AccountServicePrincipalsImpl
implements AccountServicePrincipalsService {
    private final ApiClient apiClient;

    public AccountServicePrincipalsImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public ServicePrincipal create(ServicePrincipal request) {
        String path = String.format("/api/2.0/accounts/%s/scim/v2/ServicePrincipals", this.apiClient.configuredAccountID());
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, ServicePrincipal.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void delete(DeleteAccountServicePrincipalRequest request) {
        String path = String.format("/api/2.0/accounts/%s/scim/v2/ServicePrincipals/%s", this.apiClient.configuredAccountID(), request.getId());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            this.apiClient.execute(req, DeleteResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ServicePrincipal get(GetAccountServicePrincipalRequest request) {
        String path = String.format("/api/2.0/accounts/%s/scim/v2/ServicePrincipals/%s", this.apiClient.configuredAccountID(), request.getId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ServicePrincipal.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListServicePrincipalResponse list(ListAccountServicePrincipalsRequest request) {
        String path = String.format("/api/2.0/accounts/%s/scim/v2/ServicePrincipals", this.apiClient.configuredAccountID());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListServicePrincipalResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void patch(PartialUpdate request) {
        String path = String.format("/api/2.0/accounts/%s/scim/v2/ServicePrincipals/%s", this.apiClient.configuredAccountID(), request.getId());
        try {
            Request req = new Request("PATCH", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Content-Type", "application/json");
            this.apiClient.execute(req, PatchResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void update(ServicePrincipal request) {
        String path = String.format("/api/2.0/accounts/%s/scim/v2/ServicePrincipals/%s", this.apiClient.configuredAccountID(), request.getId());
        try {
            Request req = new Request("PUT", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Content-Type", "application/json");
            this.apiClient.execute(req, UpdateResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

