/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.marketplace;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.core.DatabricksException;
import com.databricks.internal.sdk.core.http.Request;
import com.databricks.internal.sdk.service.marketplace.ConsumerInstallationsService;
import com.databricks.internal.sdk.service.marketplace.CreateInstallationRequest;
import com.databricks.internal.sdk.service.marketplace.DeleteInstallationRequest;
import com.databricks.internal.sdk.service.marketplace.DeleteInstallationResponse;
import com.databricks.internal.sdk.service.marketplace.Installation;
import com.databricks.internal.sdk.service.marketplace.ListAllInstallationsRequest;
import com.databricks.internal.sdk.service.marketplace.ListAllInstallationsResponse;
import com.databricks.internal.sdk.service.marketplace.ListInstallationsRequest;
import com.databricks.internal.sdk.service.marketplace.ListInstallationsResponse;
import com.databricks.internal.sdk.service.marketplace.UpdateInstallationRequest;
import com.databricks.internal.sdk.service.marketplace.UpdateInstallationResponse;
import com.databricks.internal.sdk.support.Generated;
import java.io.IOException;

@Generated
class ConsumerInstallationsImpl
implements ConsumerInstallationsService {
    private final ApiClient apiClient;

    public ConsumerInstallationsImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public Installation create(CreateInstallationRequest request) {
        String path = String.format("/api/2.1/marketplace-consumer/listings/%s/installations", request.getListingId());
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, Installation.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void delete(DeleteInstallationRequest request) {
        String path = String.format("/api/2.1/marketplace-consumer/listings/%s/installations/%s", request.getListingId(), request.getInstallationId());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            this.apiClient.execute(req, DeleteInstallationResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListAllInstallationsResponse list(ListAllInstallationsRequest request) {
        String path = "/api/2.1/marketplace-consumer/installations";
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListAllInstallationsResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListInstallationsResponse listListingInstallations(ListInstallationsRequest request) {
        String path = String.format("/api/2.1/marketplace-consumer/listings/%s/installations", request.getListingId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListInstallationsResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public UpdateInstallationResponse update(UpdateInstallationRequest request) {
        String path = String.format("/api/2.1/marketplace-consumer/listings/%s/installations/%s", request.getListingId(), request.getInstallationId());
        try {
            Request req = new Request("PUT", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, UpdateInstallationResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

