/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.marketplace;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.service.marketplace.CreateExchangeFilterRequest;
import com.databricks.internal.sdk.service.marketplace.CreateExchangeFilterResponse;
import com.databricks.internal.sdk.service.marketplace.DeleteExchangeFilterRequest;
import com.databricks.internal.sdk.service.marketplace.ExchangeFilter;
import com.databricks.internal.sdk.service.marketplace.ListExchangeFiltersRequest;
import com.databricks.internal.sdk.service.marketplace.ListExchangeFiltersResponse;
import com.databricks.internal.sdk.service.marketplace.ProviderExchangeFiltersImpl;
import com.databricks.internal.sdk.service.marketplace.ProviderExchangeFiltersService;
import com.databricks.internal.sdk.service.marketplace.UpdateExchangeFilterRequest;
import com.databricks.internal.sdk.service.marketplace.UpdateExchangeFilterResponse;
import com.databricks.internal.sdk.support.Generated;
import com.databricks.internal.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class ProviderExchangeFiltersAPI {
    private static final Logger LOG = LoggerFactory.getLogger(ProviderExchangeFiltersAPI.class);
    private final ProviderExchangeFiltersService impl;

    public ProviderExchangeFiltersAPI(ApiClient apiClient) {
        this.impl = new ProviderExchangeFiltersImpl(apiClient);
    }

    public ProviderExchangeFiltersAPI(ProviderExchangeFiltersService mock) {
        this.impl = mock;
    }

    public CreateExchangeFilterResponse create(ExchangeFilter filter) {
        return this.create(new CreateExchangeFilterRequest().setFilter(filter));
    }

    public CreateExchangeFilterResponse create(CreateExchangeFilterRequest request) {
        return this.impl.create(request);
    }

    public void delete(String id) {
        this.delete(new DeleteExchangeFilterRequest().setId(id));
    }

    public void delete(DeleteExchangeFilterRequest request) {
        this.impl.delete(request);
    }

    public Iterable<ExchangeFilter> list(String exchangeId) {
        return this.list(new ListExchangeFiltersRequest().setExchangeId(exchangeId));
    }

    public Iterable<ExchangeFilter> list(ListExchangeFiltersRequest request) {
        return new Paginator(request, this.impl::list, ListExchangeFiltersResponse::getFilters, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public UpdateExchangeFilterResponse update(String id, ExchangeFilter filter) {
        return this.update(new UpdateExchangeFilterRequest().setId(id).setFilter(filter));
    }

    public UpdateExchangeFilterResponse update(UpdateExchangeFilterRequest request) {
        return this.impl.update(request);
    }

    public ProviderExchangeFiltersService impl() {
        return this.impl;
    }
}

