/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.marketplace;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.service.marketplace.ListAllPersonalizationRequestsRequest;
import com.databricks.internal.sdk.service.marketplace.ListAllPersonalizationRequestsResponse;
import com.databricks.internal.sdk.service.marketplace.PersonalizationRequest;
import com.databricks.internal.sdk.service.marketplace.PersonalizationRequestStatus;
import com.databricks.internal.sdk.service.marketplace.ProviderPersonalizationRequestsImpl;
import com.databricks.internal.sdk.service.marketplace.ProviderPersonalizationRequestsService;
import com.databricks.internal.sdk.service.marketplace.UpdatePersonalizationRequestRequest;
import com.databricks.internal.sdk.service.marketplace.UpdatePersonalizationRequestResponse;
import com.databricks.internal.sdk.support.Generated;
import com.databricks.internal.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class ProviderPersonalizationRequestsAPI {
    private static final Logger LOG = LoggerFactory.getLogger(ProviderPersonalizationRequestsAPI.class);
    private final ProviderPersonalizationRequestsService impl;

    public ProviderPersonalizationRequestsAPI(ApiClient apiClient) {
        this.impl = new ProviderPersonalizationRequestsImpl(apiClient);
    }

    public ProviderPersonalizationRequestsAPI(ProviderPersonalizationRequestsService mock) {
        this.impl = mock;
    }

    public Iterable<PersonalizationRequest> list(ListAllPersonalizationRequestsRequest request) {
        return new Paginator(request, this.impl::list, ListAllPersonalizationRequestsResponse::getPersonalizationRequests, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public UpdatePersonalizationRequestResponse update(String listingId, String requestId, PersonalizationRequestStatus status) {
        return this.update(new UpdatePersonalizationRequestRequest().setListingId(listingId).setRequestId(requestId).setStatus(status));
    }

    public UpdatePersonalizationRequestResponse update(UpdatePersonalizationRequestRequest request) {
        return this.impl.update(request);
    }

    public ProviderPersonalizationRequestsService impl() {
        return this.impl;
    }
}

