/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.oauth2;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.service.oauth2.AccountFederationPolicyImpl;
import com.databricks.internal.sdk.service.oauth2.AccountFederationPolicyService;
import com.databricks.internal.sdk.service.oauth2.CreateAccountFederationPolicyRequest;
import com.databricks.internal.sdk.service.oauth2.DeleteAccountFederationPolicyRequest;
import com.databricks.internal.sdk.service.oauth2.FederationPolicy;
import com.databricks.internal.sdk.service.oauth2.GetAccountFederationPolicyRequest;
import com.databricks.internal.sdk.service.oauth2.ListAccountFederationPoliciesRequest;
import com.databricks.internal.sdk.service.oauth2.ListFederationPoliciesResponse;
import com.databricks.internal.sdk.service.oauth2.UpdateAccountFederationPolicyRequest;
import com.databricks.internal.sdk.support.Generated;
import com.databricks.internal.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class AccountFederationPolicyAPI {
    private static final Logger LOG = LoggerFactory.getLogger(AccountFederationPolicyAPI.class);
    private final AccountFederationPolicyService impl;

    public AccountFederationPolicyAPI(ApiClient apiClient) {
        this.impl = new AccountFederationPolicyImpl(apiClient);
    }

    public AccountFederationPolicyAPI(AccountFederationPolicyService mock) {
        this.impl = mock;
    }

    public FederationPolicy create(FederationPolicy policy) {
        return this.create(new CreateAccountFederationPolicyRequest().setPolicy(policy));
    }

    public FederationPolicy create(CreateAccountFederationPolicyRequest request) {
        return this.impl.create(request);
    }

    public void delete(String policyId) {
        this.delete(new DeleteAccountFederationPolicyRequest().setPolicyId(policyId));
    }

    public void delete(DeleteAccountFederationPolicyRequest request) {
        this.impl.delete(request);
    }

    public FederationPolicy get(String policyId) {
        return this.get(new GetAccountFederationPolicyRequest().setPolicyId(policyId));
    }

    public FederationPolicy get(GetAccountFederationPolicyRequest request) {
        return this.impl.get(request);
    }

    public Iterable<FederationPolicy> list(ListAccountFederationPoliciesRequest request) {
        return new Paginator(request, this.impl::list, ListFederationPoliciesResponse::getPolicies, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public FederationPolicy update(String policyId, FederationPolicy policy) {
        return this.update(new UpdateAccountFederationPolicyRequest().setPolicyId(policyId).setPolicy(policy));
    }

    public FederationPolicy update(UpdateAccountFederationPolicyRequest request) {
        return this.impl.update(request);
    }

    public AccountFederationPolicyService impl() {
        return this.impl;
    }
}

