/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.oauth2;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.service.oauth2.CreateServicePrincipalSecretRequest;
import com.databricks.internal.sdk.service.oauth2.CreateServicePrincipalSecretResponse;
import com.databricks.internal.sdk.service.oauth2.DeleteServicePrincipalSecretRequest;
import com.databricks.internal.sdk.service.oauth2.ListServicePrincipalSecretsRequest;
import com.databricks.internal.sdk.service.oauth2.ListServicePrincipalSecretsResponse;
import com.databricks.internal.sdk.service.oauth2.SecretInfo;
import com.databricks.internal.sdk.service.oauth2.ServicePrincipalSecretsImpl;
import com.databricks.internal.sdk.service.oauth2.ServicePrincipalSecretsService;
import com.databricks.internal.sdk.support.Generated;
import com.databricks.internal.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class ServicePrincipalSecretsAPI {
    private static final Logger LOG = LoggerFactory.getLogger(ServicePrincipalSecretsAPI.class);
    private final ServicePrincipalSecretsService impl;

    public ServicePrincipalSecretsAPI(ApiClient apiClient) {
        this.impl = new ServicePrincipalSecretsImpl(apiClient);
    }

    public ServicePrincipalSecretsAPI(ServicePrincipalSecretsService mock) {
        this.impl = mock;
    }

    public CreateServicePrincipalSecretResponse create(long servicePrincipalId) {
        return this.create(new CreateServicePrincipalSecretRequest().setServicePrincipalId(servicePrincipalId));
    }

    public CreateServicePrincipalSecretResponse create(CreateServicePrincipalSecretRequest request) {
        return this.impl.create(request);
    }

    public void delete(long servicePrincipalId, String secretId) {
        this.delete(new DeleteServicePrincipalSecretRequest().setServicePrincipalId(servicePrincipalId).setSecretId(secretId));
    }

    public void delete(DeleteServicePrincipalSecretRequest request) {
        this.impl.delete(request);
    }

    public Iterable<SecretInfo> list(long servicePrincipalId) {
        return this.list(new ListServicePrincipalSecretsRequest().setServicePrincipalId(servicePrincipalId));
    }

    public Iterable<SecretInfo> list(ListServicePrincipalSecretsRequest request) {
        return new Paginator(request, this.impl::list, ListServicePrincipalSecretsResponse::getSecrets, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public ServicePrincipalSecretsService impl() {
        return this.impl;
    }
}

