/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.provisioning;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.core.DatabricksException;
import com.databricks.internal.sdk.service.provisioning.CreateWorkspaceRequest;
import com.databricks.internal.sdk.service.provisioning.DeleteWorkspaceRequest;
import com.databricks.internal.sdk.service.provisioning.GetWorkspaceRequest;
import com.databricks.internal.sdk.service.provisioning.UpdateWorkspaceRequest;
import com.databricks.internal.sdk.service.provisioning.Workspace;
import com.databricks.internal.sdk.service.provisioning.WorkspaceStatus;
import com.databricks.internal.sdk.service.provisioning.WorkspacesImpl;
import com.databricks.internal.sdk.service.provisioning.WorkspacesService;
import com.databricks.internal.sdk.support.Generated;
import com.databricks.internal.sdk.support.Wait;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class WorkspacesAPI {
    private static final Logger LOG = LoggerFactory.getLogger(WorkspacesAPI.class);
    private final WorkspacesService impl;

    public WorkspacesAPI(ApiClient apiClient) {
        this.impl = new WorkspacesImpl(apiClient);
    }

    public WorkspacesAPI(WorkspacesService mock) {
        this.impl = mock;
    }

    public Workspace waitGetWorkspaceRunning(Long workspaceId) throws TimeoutException {
        return this.waitGetWorkspaceRunning(workspaceId, Duration.ofMinutes(20L), null);
    }

    public Workspace waitGetWorkspaceRunning(Long workspaceId, Duration timeout, Consumer<Workspace> callback) throws TimeoutException {
        long deadline = System.currentTimeMillis() + timeout.toMillis();
        List<WorkspaceStatus> targetStates = Arrays.asList(WorkspaceStatus.RUNNING);
        List<WorkspaceStatus> failureStates = Arrays.asList(WorkspaceStatus.BANNED, WorkspaceStatus.FAILED);
        String statusMessage = "polling...";
        int attempt = 1;
        while (System.currentTimeMillis() < deadline) {
            Workspace poll = this.get(new GetWorkspaceRequest().setWorkspaceId(workspaceId));
            WorkspaceStatus status = poll.getWorkspaceStatus();
            statusMessage = poll.getWorkspaceStatusMessage();
            if (targetStates.contains((Object)status)) {
                return poll;
            }
            if (callback != null) {
                callback.accept(poll);
            }
            if (failureStates.contains((Object)status)) {
                String msg = String.format("failed to reach RUNNING, got %s: %s", new Object[]{status, statusMessage});
                throw new IllegalStateException(msg);
            }
            String prefix = String.format("workspaceId=%s", workspaceId);
            int sleep = attempt;
            if (sleep > 10) {
                sleep = 10;
            }
            LOG.info("{}: ({}) {} (sleeping ~{}s)", new Object[]{prefix, status, statusMessage, sleep});
            try {
                Thread.sleep((long)((double)((long)sleep * 1000L) + Math.random() * 1000.0));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new DatabricksException("Current thread was interrupted", e);
            }
            ++attempt;
        }
        throw new TimeoutException(String.format("timed out after %s: %s", timeout, statusMessage));
    }

    public Wait<Workspace, Workspace> create(String workspaceName) {
        return this.create(new CreateWorkspaceRequest().setWorkspaceName(workspaceName));
    }

    public Wait<Workspace, Workspace> create(CreateWorkspaceRequest request) {
        Workspace response = this.impl.create(request);
        return new Wait<Workspace, Workspace>((timeout, callback) -> this.waitGetWorkspaceRunning(response.getWorkspaceId(), timeout, callback), response);
    }

    public void delete(long workspaceId) {
        this.delete(new DeleteWorkspaceRequest().setWorkspaceId(workspaceId));
    }

    public void delete(DeleteWorkspaceRequest request) {
        this.impl.delete(request);
    }

    public Workspace get(long workspaceId) {
        return this.get(new GetWorkspaceRequest().setWorkspaceId(workspaceId));
    }

    public Workspace get(GetWorkspaceRequest request) {
        return this.impl.get(request);
    }

    public Iterable<Workspace> list() {
        return this.impl.list();
    }

    public Wait<Workspace, Void> update(long workspaceId) {
        return this.update(new UpdateWorkspaceRequest().setWorkspaceId(workspaceId));
    }

    public Wait<Workspace, Void> update(UpdateWorkspaceRequest request) {
        this.impl.update(request);
        return new Wait<Workspace, Void>((timeout, callback) -> this.waitGetWorkspaceRunning(request.getWorkspaceId(), timeout, callback));
    }

    public WorkspacesService impl() {
        return this.impl;
    }
}

