/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.settings;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.service.settings.CreateNetworkConnectivityConfigRequest;
import com.databricks.internal.sdk.service.settings.CreateNetworkConnectivityConfiguration;
import com.databricks.internal.sdk.service.settings.CreatePrivateEndpointRule;
import com.databricks.internal.sdk.service.settings.CreatePrivateEndpointRuleRequest;
import com.databricks.internal.sdk.service.settings.DeleteNetworkConnectivityConfigurationRequest;
import com.databricks.internal.sdk.service.settings.DeletePrivateEndpointRuleRequest;
import com.databricks.internal.sdk.service.settings.GetNetworkConnectivityConfigurationRequest;
import com.databricks.internal.sdk.service.settings.GetPrivateEndpointRuleRequest;
import com.databricks.internal.sdk.service.settings.ListNccAzurePrivateEndpointRulesResponse;
import com.databricks.internal.sdk.service.settings.ListNetworkConnectivityConfigurationsRequest;
import com.databricks.internal.sdk.service.settings.ListNetworkConnectivityConfigurationsResponse;
import com.databricks.internal.sdk.service.settings.ListPrivateEndpointRulesRequest;
import com.databricks.internal.sdk.service.settings.NccAzurePrivateEndpointRule;
import com.databricks.internal.sdk.service.settings.NetworkConnectivityConfiguration;
import com.databricks.internal.sdk.service.settings.NetworkConnectivityImpl;
import com.databricks.internal.sdk.service.settings.NetworkConnectivityService;
import com.databricks.internal.sdk.service.settings.UpdateNccAzurePrivateEndpointRulePublicRequest;
import com.databricks.internal.sdk.service.settings.UpdatePrivateEndpointRule;
import com.databricks.internal.sdk.support.Generated;
import com.databricks.internal.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class NetworkConnectivityAPI {
    private static final Logger LOG = LoggerFactory.getLogger(NetworkConnectivityAPI.class);
    private final NetworkConnectivityService impl;

    public NetworkConnectivityAPI(ApiClient apiClient) {
        this.impl = new NetworkConnectivityImpl(apiClient);
    }

    public NetworkConnectivityAPI(NetworkConnectivityService mock) {
        this.impl = mock;
    }

    public NetworkConnectivityConfiguration createNetworkConnectivityConfiguration(CreateNetworkConnectivityConfiguration networkConnectivityConfig) {
        return this.createNetworkConnectivityConfiguration(new CreateNetworkConnectivityConfigRequest().setNetworkConnectivityConfig(networkConnectivityConfig));
    }

    public NetworkConnectivityConfiguration createNetworkConnectivityConfiguration(CreateNetworkConnectivityConfigRequest request) {
        return this.impl.createNetworkConnectivityConfiguration(request);
    }

    public NccAzurePrivateEndpointRule createPrivateEndpointRule(String networkConnectivityConfigId, CreatePrivateEndpointRule privateEndpointRule) {
        return this.createPrivateEndpointRule(new CreatePrivateEndpointRuleRequest().setNetworkConnectivityConfigId(networkConnectivityConfigId).setPrivateEndpointRule(privateEndpointRule));
    }

    public NccAzurePrivateEndpointRule createPrivateEndpointRule(CreatePrivateEndpointRuleRequest request) {
        return this.impl.createPrivateEndpointRule(request);
    }

    public void deleteNetworkConnectivityConfiguration(String networkConnectivityConfigId) {
        this.deleteNetworkConnectivityConfiguration(new DeleteNetworkConnectivityConfigurationRequest().setNetworkConnectivityConfigId(networkConnectivityConfigId));
    }

    public void deleteNetworkConnectivityConfiguration(DeleteNetworkConnectivityConfigurationRequest request) {
        this.impl.deleteNetworkConnectivityConfiguration(request);
    }

    public NccAzurePrivateEndpointRule deletePrivateEndpointRule(String networkConnectivityConfigId, String privateEndpointRuleId) {
        return this.deletePrivateEndpointRule(new DeletePrivateEndpointRuleRequest().setNetworkConnectivityConfigId(networkConnectivityConfigId).setPrivateEndpointRuleId(privateEndpointRuleId));
    }

    public NccAzurePrivateEndpointRule deletePrivateEndpointRule(DeletePrivateEndpointRuleRequest request) {
        return this.impl.deletePrivateEndpointRule(request);
    }

    public NetworkConnectivityConfiguration getNetworkConnectivityConfiguration(String networkConnectivityConfigId) {
        return this.getNetworkConnectivityConfiguration(new GetNetworkConnectivityConfigurationRequest().setNetworkConnectivityConfigId(networkConnectivityConfigId));
    }

    public NetworkConnectivityConfiguration getNetworkConnectivityConfiguration(GetNetworkConnectivityConfigurationRequest request) {
        return this.impl.getNetworkConnectivityConfiguration(request);
    }

    public NccAzurePrivateEndpointRule getPrivateEndpointRule(String networkConnectivityConfigId, String privateEndpointRuleId) {
        return this.getPrivateEndpointRule(new GetPrivateEndpointRuleRequest().setNetworkConnectivityConfigId(networkConnectivityConfigId).setPrivateEndpointRuleId(privateEndpointRuleId));
    }

    public NccAzurePrivateEndpointRule getPrivateEndpointRule(GetPrivateEndpointRuleRequest request) {
        return this.impl.getPrivateEndpointRule(request);
    }

    public Iterable<NetworkConnectivityConfiguration> listNetworkConnectivityConfigurations(ListNetworkConnectivityConfigurationsRequest request) {
        return new Paginator(request, this.impl::listNetworkConnectivityConfigurations, ListNetworkConnectivityConfigurationsResponse::getItems, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public Iterable<NccAzurePrivateEndpointRule> listPrivateEndpointRules(String networkConnectivityConfigId) {
        return this.listPrivateEndpointRules(new ListPrivateEndpointRulesRequest().setNetworkConnectivityConfigId(networkConnectivityConfigId));
    }

    public Iterable<NccAzurePrivateEndpointRule> listPrivateEndpointRules(ListPrivateEndpointRulesRequest request) {
        return new Paginator(request, this.impl::listPrivateEndpointRules, ListNccAzurePrivateEndpointRulesResponse::getItems, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public NccAzurePrivateEndpointRule updateNccAzurePrivateEndpointRulePublic(String networkConnectivityConfigId, String privateEndpointRuleId, UpdatePrivateEndpointRule privateEndpointRule, String updateMask) {
        return this.updateNccAzurePrivateEndpointRulePublic(new UpdateNccAzurePrivateEndpointRulePublicRequest().setNetworkConnectivityConfigId(networkConnectivityConfigId).setPrivateEndpointRuleId(privateEndpointRuleId).setPrivateEndpointRule(privateEndpointRule).setUpdateMask(updateMask));
    }

    public NccAzurePrivateEndpointRule updateNccAzurePrivateEndpointRulePublic(UpdateNccAzurePrivateEndpointRulePublicRequest request) {
        return this.impl.updateNccAzurePrivateEndpointRulePublic(request);
    }

    public NetworkConnectivityService impl() {
        return this.impl;
    }
}

