/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.settings;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.core.DatabricksException;
import com.databricks.internal.sdk.core.http.Request;
import com.databricks.internal.sdk.service.settings.CreateNetworkConnectivityConfigRequest;
import com.databricks.internal.sdk.service.settings.CreatePrivateEndpointRuleRequest;
import com.databricks.internal.sdk.service.settings.DeleteNetworkConnectivityConfigurationRequest;
import com.databricks.internal.sdk.service.settings.DeleteNetworkConnectivityConfigurationResponse;
import com.databricks.internal.sdk.service.settings.DeletePrivateEndpointRuleRequest;
import com.databricks.internal.sdk.service.settings.GetNetworkConnectivityConfigurationRequest;
import com.databricks.internal.sdk.service.settings.GetPrivateEndpointRuleRequest;
import com.databricks.internal.sdk.service.settings.ListNccAzurePrivateEndpointRulesResponse;
import com.databricks.internal.sdk.service.settings.ListNetworkConnectivityConfigurationsRequest;
import com.databricks.internal.sdk.service.settings.ListNetworkConnectivityConfigurationsResponse;
import com.databricks.internal.sdk.service.settings.ListPrivateEndpointRulesRequest;
import com.databricks.internal.sdk.service.settings.NccAzurePrivateEndpointRule;
import com.databricks.internal.sdk.service.settings.NetworkConnectivityConfiguration;
import com.databricks.internal.sdk.service.settings.NetworkConnectivityService;
import com.databricks.internal.sdk.service.settings.UpdateNccAzurePrivateEndpointRulePublicRequest;
import com.databricks.internal.sdk.support.Generated;
import java.io.IOException;

@Generated
class NetworkConnectivityImpl
implements NetworkConnectivityService {
    private final ApiClient apiClient;

    public NetworkConnectivityImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public NetworkConnectivityConfiguration createNetworkConnectivityConfiguration(CreateNetworkConnectivityConfigRequest request) {
        String path = String.format("/api/2.0/accounts/%s/network-connectivity-configs", this.apiClient.configuredAccountID());
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request.getNetworkConnectivityConfig()));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, NetworkConnectivityConfiguration.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public NccAzurePrivateEndpointRule createPrivateEndpointRule(CreatePrivateEndpointRuleRequest request) {
        String path = String.format("/api/2.0/accounts/%s/network-connectivity-configs/%s/private-endpoint-rules", this.apiClient.configuredAccountID(), request.getNetworkConnectivityConfigId());
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request.getPrivateEndpointRule()));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, NccAzurePrivateEndpointRule.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void deleteNetworkConnectivityConfiguration(DeleteNetworkConnectivityConfigurationRequest request) {
        String path = String.format("/api/2.0/accounts/%s/network-connectivity-configs/%s", this.apiClient.configuredAccountID(), request.getNetworkConnectivityConfigId());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            this.apiClient.execute(req, DeleteNetworkConnectivityConfigurationResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public NccAzurePrivateEndpointRule deletePrivateEndpointRule(DeletePrivateEndpointRuleRequest request) {
        String path = String.format("/api/2.0/accounts/%s/network-connectivity-configs/%s/private-endpoint-rules/%s", this.apiClient.configuredAccountID(), request.getNetworkConnectivityConfigId(), request.getPrivateEndpointRuleId());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, NccAzurePrivateEndpointRule.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public NetworkConnectivityConfiguration getNetworkConnectivityConfiguration(GetNetworkConnectivityConfigurationRequest request) {
        String path = String.format("/api/2.0/accounts/%s/network-connectivity-configs/%s", this.apiClient.configuredAccountID(), request.getNetworkConnectivityConfigId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, NetworkConnectivityConfiguration.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public NccAzurePrivateEndpointRule getPrivateEndpointRule(GetPrivateEndpointRuleRequest request) {
        String path = String.format("/api/2.0/accounts/%s/network-connectivity-configs/%s/private-endpoint-rules/%s", this.apiClient.configuredAccountID(), request.getNetworkConnectivityConfigId(), request.getPrivateEndpointRuleId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, NccAzurePrivateEndpointRule.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListNetworkConnectivityConfigurationsResponse listNetworkConnectivityConfigurations(ListNetworkConnectivityConfigurationsRequest request) {
        String path = String.format("/api/2.0/accounts/%s/network-connectivity-configs", this.apiClient.configuredAccountID());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListNetworkConnectivityConfigurationsResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListNccAzurePrivateEndpointRulesResponse listPrivateEndpointRules(ListPrivateEndpointRulesRequest request) {
        String path = String.format("/api/2.0/accounts/%s/network-connectivity-configs/%s/private-endpoint-rules", this.apiClient.configuredAccountID(), request.getNetworkConnectivityConfigId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListNccAzurePrivateEndpointRulesResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public NccAzurePrivateEndpointRule updateNccAzurePrivateEndpointRulePublic(UpdateNccAzurePrivateEndpointRulePublicRequest request) {
        String path = String.format("/api/2.0/accounts/%s/network-connectivity-configs/%s/private-endpoint-rules/%s", this.apiClient.configuredAccountID(), request.getNetworkConnectivityConfigId(), request.getPrivateEndpointRuleId());
        try {
            Request req = new Request("PATCH", path, this.apiClient.serialize(request.getPrivateEndpointRule()));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, NccAzurePrivateEndpointRule.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

