/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.settings;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.service.settings.AccountNetworkPolicy;
import com.databricks.internal.sdk.service.settings.CreateNetworkPolicyRequest;
import com.databricks.internal.sdk.service.settings.DeleteNetworkPolicyRequest;
import com.databricks.internal.sdk.service.settings.GetNetworkPolicyRequest;
import com.databricks.internal.sdk.service.settings.ListNetworkPoliciesRequest;
import com.databricks.internal.sdk.service.settings.ListNetworkPoliciesResponse;
import com.databricks.internal.sdk.service.settings.NetworkPoliciesImpl;
import com.databricks.internal.sdk.service.settings.NetworkPoliciesService;
import com.databricks.internal.sdk.service.settings.UpdateNetworkPolicyRequest;
import com.databricks.internal.sdk.support.Generated;
import com.databricks.internal.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class NetworkPoliciesAPI {
    private static final Logger LOG = LoggerFactory.getLogger(NetworkPoliciesAPI.class);
    private final NetworkPoliciesService impl;

    public NetworkPoliciesAPI(ApiClient apiClient) {
        this.impl = new NetworkPoliciesImpl(apiClient);
    }

    public NetworkPoliciesAPI(NetworkPoliciesService mock) {
        this.impl = mock;
    }

    public AccountNetworkPolicy createNetworkPolicyRpc(AccountNetworkPolicy networkPolicy) {
        return this.createNetworkPolicyRpc(new CreateNetworkPolicyRequest().setNetworkPolicy(networkPolicy));
    }

    public AccountNetworkPolicy createNetworkPolicyRpc(CreateNetworkPolicyRequest request) {
        return this.impl.createNetworkPolicyRpc(request);
    }

    public void deleteNetworkPolicyRpc(String networkPolicyId) {
        this.deleteNetworkPolicyRpc(new DeleteNetworkPolicyRequest().setNetworkPolicyId(networkPolicyId));
    }

    public void deleteNetworkPolicyRpc(DeleteNetworkPolicyRequest request) {
        this.impl.deleteNetworkPolicyRpc(request);
    }

    public AccountNetworkPolicy getNetworkPolicyRpc(String networkPolicyId) {
        return this.getNetworkPolicyRpc(new GetNetworkPolicyRequest().setNetworkPolicyId(networkPolicyId));
    }

    public AccountNetworkPolicy getNetworkPolicyRpc(GetNetworkPolicyRequest request) {
        return this.impl.getNetworkPolicyRpc(request);
    }

    public Iterable<AccountNetworkPolicy> listNetworkPoliciesRpc(ListNetworkPoliciesRequest request) {
        return new Paginator(request, this.impl::listNetworkPoliciesRpc, ListNetworkPoliciesResponse::getItems, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public AccountNetworkPolicy updateNetworkPolicyRpc(String networkPolicyId, AccountNetworkPolicy networkPolicy) {
        return this.updateNetworkPolicyRpc(new UpdateNetworkPolicyRequest().setNetworkPolicyId(networkPolicyId).setNetworkPolicy(networkPolicy));
    }

    public AccountNetworkPolicy updateNetworkPolicyRpc(UpdateNetworkPolicyRequest request) {
        return this.impl.updateNetworkPolicyRpc(request);
    }

    public NetworkPoliciesService impl() {
        return this.impl;
    }
}

