/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.settings;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.core.DatabricksException;
import com.databricks.internal.sdk.core.http.Request;
import com.databricks.internal.sdk.service.settings.CreateOboTokenRequest;
import com.databricks.internal.sdk.service.settings.CreateOboTokenResponse;
import com.databricks.internal.sdk.service.settings.DeleteResponse;
import com.databricks.internal.sdk.service.settings.DeleteTokenManagementRequest;
import com.databricks.internal.sdk.service.settings.GetTokenManagementRequest;
import com.databricks.internal.sdk.service.settings.GetTokenPermissionLevelsResponse;
import com.databricks.internal.sdk.service.settings.GetTokenResponse;
import com.databricks.internal.sdk.service.settings.ListTokenManagementRequest;
import com.databricks.internal.sdk.service.settings.ListTokensResponse;
import com.databricks.internal.sdk.service.settings.TokenManagementService;
import com.databricks.internal.sdk.service.settings.TokenPermissions;
import com.databricks.internal.sdk.service.settings.TokenPermissionsRequest;
import com.databricks.internal.sdk.support.Generated;
import java.io.IOException;

@Generated
class TokenManagementImpl
implements TokenManagementService {
    private final ApiClient apiClient;

    public TokenManagementImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public CreateOboTokenResponse createOboToken(CreateOboTokenRequest request) {
        String path = "/api/2.0/token-management/on-behalf-of/tokens";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, CreateOboTokenResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void delete(DeleteTokenManagementRequest request) {
        String path = String.format("/api/2.0/token-management/tokens/%s", request.getTokenId());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            this.apiClient.execute(req, DeleteResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public GetTokenResponse get(GetTokenManagementRequest request) {
        String path = String.format("/api/2.0/token-management/tokens/%s", request.getTokenId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, GetTokenResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public GetTokenPermissionLevelsResponse getPermissionLevels() {
        String path = "/api/2.0/permissions/authorization/tokens/permissionLevels";
        try {
            Request req = new Request("GET", path);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, GetTokenPermissionLevelsResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public TokenPermissions getPermissions() {
        String path = "/api/2.0/permissions/authorization/tokens";
        try {
            Request req = new Request("GET", path);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, TokenPermissions.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListTokensResponse list(ListTokenManagementRequest request) {
        String path = "/api/2.0/token-management/tokens";
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListTokensResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public TokenPermissions setPermissions(TokenPermissionsRequest request) {
        String path = "/api/2.0/permissions/authorization/tokens";
        try {
            Request req = new Request("PUT", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, TokenPermissions.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public TokenPermissions updatePermissions(TokenPermissionsRequest request) {
        String path = "/api/2.0/permissions/authorization/tokens";
        try {
            Request req = new Request("PATCH", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, TokenPermissions.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

