/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.sharing;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.core.DatabricksException;
import com.databricks.internal.sdk.core.http.Request;
import com.databricks.internal.sdk.service.sharing.CreateRecipient;
import com.databricks.internal.sdk.service.sharing.DeleteRecipientRequest;
import com.databricks.internal.sdk.service.sharing.DeleteResponse;
import com.databricks.internal.sdk.service.sharing.GetRecipientRequest;
import com.databricks.internal.sdk.service.sharing.GetRecipientSharePermissionsResponse;
import com.databricks.internal.sdk.service.sharing.ListRecipientsRequest;
import com.databricks.internal.sdk.service.sharing.ListRecipientsResponse;
import com.databricks.internal.sdk.service.sharing.RecipientInfo;
import com.databricks.internal.sdk.service.sharing.RecipientsService;
import com.databricks.internal.sdk.service.sharing.RotateRecipientToken;
import com.databricks.internal.sdk.service.sharing.SharePermissionsRequest;
import com.databricks.internal.sdk.service.sharing.UpdateRecipient;
import com.databricks.internal.sdk.support.Generated;
import java.io.IOException;

@Generated
class RecipientsImpl
implements RecipientsService {
    private final ApiClient apiClient;

    public RecipientsImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public RecipientInfo create(CreateRecipient request) {
        String path = "/api/2.1/unity-catalog/recipients";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, RecipientInfo.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void delete(DeleteRecipientRequest request) {
        String path = String.format("/api/2.1/unity-catalog/recipients/%s", request.getName());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            this.apiClient.execute(req, DeleteResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public RecipientInfo get(GetRecipientRequest request) {
        String path = String.format("/api/2.1/unity-catalog/recipients/%s", request.getName());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, RecipientInfo.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListRecipientsResponse list(ListRecipientsRequest request) {
        String path = "/api/2.1/unity-catalog/recipients";
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListRecipientsResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public RecipientInfo rotateToken(RotateRecipientToken request) {
        String path = String.format("/api/2.1/unity-catalog/recipients/%s/rotate-token", request.getName());
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, RecipientInfo.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public GetRecipientSharePermissionsResponse sharePermissions(SharePermissionsRequest request) {
        String path = String.format("/api/2.1/unity-catalog/recipients/%s/share-permissions", request.getName());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, GetRecipientSharePermissionsResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public RecipientInfo update(UpdateRecipient request) {
        String path = String.format("/api/2.1/unity-catalog/recipients/%s", request.getName());
        try {
            Request req = new Request("PATCH", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, RecipientInfo.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

