/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.sql;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.core.DatabricksException;
import com.databricks.internal.sdk.core.http.Request;
import com.databricks.internal.sdk.service.sql.AlertsLegacyService;
import com.databricks.internal.sdk.service.sql.CreateAlert;
import com.databricks.internal.sdk.service.sql.DeleteAlertsLegacyRequest;
import com.databricks.internal.sdk.service.sql.DeleteResponse;
import com.databricks.internal.sdk.service.sql.EditAlert;
import com.databricks.internal.sdk.service.sql.GetAlertsLegacyRequest;
import com.databricks.internal.sdk.service.sql.LegacyAlert;
import com.databricks.internal.sdk.service.sql.UpdateResponse;
import com.databricks.internal.sdk.support.Generated;
import java.io.IOException;
import java.util.Collection;

@Generated
class AlertsLegacyImpl
implements AlertsLegacyService {
    private final ApiClient apiClient;

    public AlertsLegacyImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public LegacyAlert create(CreateAlert request) {
        String path = "/api/2.0/preview/sql/alerts";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, LegacyAlert.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void delete(DeleteAlertsLegacyRequest request) {
        String path = String.format("/api/2.0/preview/sql/alerts/%s", request.getAlertId());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            this.apiClient.execute(req, DeleteResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public LegacyAlert get(GetAlertsLegacyRequest request) {
        String path = String.format("/api/2.0/preview/sql/alerts/%s", request.getAlertId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, LegacyAlert.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public Collection<LegacyAlert> list() {
        String path = "/api/2.0/preview/sql/alerts";
        Request req = new Request("GET", path);
        req.withHeader("Accept", "application/json");
        return this.apiClient.getCollection(req, LegacyAlert.class);
    }

    @Override
    public void update(EditAlert request) {
        String path = String.format("/api/2.0/preview/sql/alerts/%s", request.getAlertId());
        try {
            Request req = new Request("PUT", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            this.apiClient.execute(req, UpdateResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

