/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.sql;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.core.DatabricksException;
import com.databricks.internal.sdk.core.http.Request;
import com.databricks.internal.sdk.service.sql.AlertV2;
import com.databricks.internal.sdk.service.sql.AlertsV2Service;
import com.databricks.internal.sdk.service.sql.CreateAlertV2Request;
import com.databricks.internal.sdk.service.sql.Empty;
import com.databricks.internal.sdk.service.sql.GetAlertV2Request;
import com.databricks.internal.sdk.service.sql.ListAlertsV2Request;
import com.databricks.internal.sdk.service.sql.ListAlertsV2Response;
import com.databricks.internal.sdk.service.sql.TrashAlertV2Request;
import com.databricks.internal.sdk.service.sql.UpdateAlertV2Request;
import com.databricks.internal.sdk.support.Generated;
import java.io.IOException;

@Generated
class AlertsV2Impl
implements AlertsV2Service {
    private final ApiClient apiClient;

    public AlertsV2Impl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public AlertV2 createAlert(CreateAlertV2Request request) {
        String path = "/api/2.0/alerts";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request.getAlert()));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, AlertV2.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public AlertV2 getAlert(GetAlertV2Request request) {
        String path = String.format("/api/2.0/alerts/%s", request.getId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, AlertV2.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListAlertsV2Response listAlerts(ListAlertsV2Request request) {
        String path = "/api/2.0/alerts";
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListAlertsV2Response.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void trashAlert(TrashAlertV2Request request) {
        String path = String.format("/api/2.0/alerts/%s", request.getId());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            this.apiClient.execute(req, Empty.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public AlertV2 updateAlert(UpdateAlertV2Request request) {
        String path = String.format("/api/2.0/alerts/%s", request.getId());
        try {
            Request req = new Request("PATCH", path, this.apiClient.serialize(request.getAlert()));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, AlertV2.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

