/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.workspace;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.service.workspace.CreateCredentialsRequest;
import com.databricks.internal.sdk.service.workspace.CreateCredentialsResponse;
import com.databricks.internal.sdk.service.workspace.CredentialInfo;
import com.databricks.internal.sdk.service.workspace.DeleteCredentialsRequest;
import com.databricks.internal.sdk.service.workspace.GetCredentialsRequest;
import com.databricks.internal.sdk.service.workspace.GetCredentialsResponse;
import com.databricks.internal.sdk.service.workspace.GitCredentialsImpl;
import com.databricks.internal.sdk.service.workspace.GitCredentialsService;
import com.databricks.internal.sdk.service.workspace.ListCredentialsResponse;
import com.databricks.internal.sdk.service.workspace.UpdateCredentialsRequest;
import com.databricks.internal.sdk.support.Generated;
import com.databricks.internal.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class GitCredentialsAPI {
    private static final Logger LOG = LoggerFactory.getLogger(GitCredentialsAPI.class);
    private final GitCredentialsService impl;

    public GitCredentialsAPI(ApiClient apiClient) {
        this.impl = new GitCredentialsImpl(apiClient);
    }

    public GitCredentialsAPI(GitCredentialsService mock) {
        this.impl = mock;
    }

    public CreateCredentialsResponse create(String gitProvider) {
        return this.create(new CreateCredentialsRequest().setGitProvider(gitProvider));
    }

    public CreateCredentialsResponse create(CreateCredentialsRequest request) {
        return this.impl.create(request);
    }

    public void delete(long credentialId) {
        this.delete(new DeleteCredentialsRequest().setCredentialId(credentialId));
    }

    public void delete(DeleteCredentialsRequest request) {
        this.impl.delete(request);
    }

    public GetCredentialsResponse get(long credentialId) {
        return this.get(new GetCredentialsRequest().setCredentialId(credentialId));
    }

    public GetCredentialsResponse get(GetCredentialsRequest request) {
        return this.impl.get(request);
    }

    public Iterable<CredentialInfo> list() {
        return new Paginator(null, v -> this.impl.list(), ListCredentialsResponse::getCredentials, response -> null);
    }

    public void update(long credentialId, String gitProvider) {
        this.update(new UpdateCredentialsRequest().setCredentialId(credentialId).setGitProvider(gitProvider));
    }

    public void update(UpdateCredentialsRequest request) {
        this.impl.update(request);
    }

    public GitCredentialsService impl() {
        return this.impl;
    }
}

