/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.api.impl;

import com.databricks.internal.sdk.service.sql.ColumnInfoTypeName;
import com.databricks.jdbc.api.impl.ImmutableSqlParameter;
import com.databricks.jdbc.common.util.DatabricksTypeUtil;
import com.databricks.jdbc.common.util.WrapperUtil;
import com.databricks.jdbc.log.JdbcLogger;
import com.databricks.jdbc.log.JdbcLoggerFactory;
import java.sql.ParameterMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class DatabricksParameterMetaData
implements ParameterMetaData {
    private static final JdbcLogger LOGGER = JdbcLoggerFactory.getLogger(DatabricksParameterMetaData.class);
    private final Map<Integer, ImmutableSqlParameter> parameterBindings = new HashMap<Integer, ImmutableSqlParameter>();
    private final int parameterCount;

    public DatabricksParameterMetaData() {
        this(null);
    }

    public DatabricksParameterMetaData(String sql) {
        this.parameterCount = this.countParameters(sql);
    }

    public void put(int param, ImmutableSqlParameter value) {
        this.parameterBindings.put(param, value);
    }

    public Map<Integer, ImmutableSqlParameter> getParameterBindings() {
        return this.parameterBindings;
    }

    public void clear() {
        this.parameterBindings.clear();
    }

    @Override
    public int getParameterCount() throws SQLException {
        this.validateParameterBindings();
        return this.parameterCount;
    }

    private void validateParameterBindings() throws SQLException {
        if (this.parameterBindings.size() > this.parameterCount) {
            throw new SQLException("Number of parameter bindings (" + this.parameterBindings.size() + ") exceeds parameter count (" + this.parameterCount + ")");
        }
    }

    @Override
    public int isNullable(int param) throws SQLException {
        return 2;
    }

    @Override
    public boolean isSigned(int param) throws SQLException {
        LOGGER.warn("This feature is not fully implemented in the driver yet.");
        return DatabricksTypeUtil.isSigned(this.getObject(param).type());
    }

    @Override
    public int getPrecision(int param) throws SQLException {
        LOGGER.warn("This feature is not fully implemented in the driver yet.");
        return DatabricksTypeUtil.getPrecision(DatabricksTypeUtil.getColumnType(this.getObject(param).type()));
    }

    @Override
    public int getScale(int param) throws SQLException {
        LOGGER.warn("This feature is not fully implemented in the driver yet.");
        return DatabricksTypeUtil.getScale(DatabricksTypeUtil.getColumnType(this.getObject(param).type()));
    }

    @Override
    public int getParameterType(int param) throws SQLException {
        LOGGER.warn("This feature is not fully implemented in the driver yet.");
        return DatabricksTypeUtil.getColumnType(this.getObject(param).type());
    }

    @Override
    public String getParameterTypeName(int param) throws SQLException {
        LOGGER.warn("This feature is not fully implemented in the driver yet.");
        return this.getObject(param).type().name();
    }

    @Override
    public String getParameterClassName(int param) throws SQLException {
        LOGGER.warn("This feature is not fully implemented in the driver yet.");
        return DatabricksTypeUtil.getColumnTypeClassName(this.getObject(param).type());
    }

    @Override
    public int getParameterMode(int param) throws SQLException {
        LOGGER.warn("This feature is not fully implemented in the driver yet.");
        return 1;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return WrapperUtil.unwrap(iface, this);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return WrapperUtil.isWrapperFor(iface, this);
    }

    private ImmutableSqlParameter getObject(int param) {
        if (!this.parameterBindings.containsKey(param)) {
            LOGGER.info("Parameter not added in the prepared statement yet. Sending default value");
            return ImmutableSqlParameter.builder().type(ColumnInfoTypeName.STRING).cardinal(1).value("").build();
        }
        return this.parameterBindings.get(param);
    }

    private int countParameters(String sql) {
        if (sql == null || sql.isEmpty()) {
            return 0;
        }
        int count = 0;
        boolean inSingleQuote = false;
        boolean inDoubleQuote = false;
        boolean inLineComment = false;
        boolean inBlockComment = false;
        for (int i = 0; i < sql.length(); ++i) {
            char next;
            char c = sql.charAt(i);
            char c2 = next = i < sql.length() - 1 ? sql.charAt(i + 1) : (char)'\u0000';
            if (!inSingleQuote && !inDoubleQuote) {
                if (!inBlockComment && !inLineComment && c == '-' && next == '-') {
                    inLineComment = true;
                    ++i;
                    continue;
                }
                if (!inBlockComment && !inLineComment && c == '/' && next == '*') {
                    inBlockComment = true;
                    ++i;
                    continue;
                }
                if (inLineComment && (c == '\n' || c == '\r')) {
                    inLineComment = false;
                } else if (inBlockComment && c == '*' && next == '/') {
                    inBlockComment = false;
                    ++i;
                    continue;
                }
            }
            if (inLineComment || inBlockComment) continue;
            if (c == '\'') {
                if (!inDoubleQuote) {
                    if (inSingleQuote && i < sql.length() - 1 && sql.charAt(i + 1) == '\'') {
                        ++i;
                    } else {
                        inSingleQuote = !inSingleQuote;
                    }
                }
            } else if (c == '\"' && !inSingleQuote) {
                if (inDoubleQuote && i < sql.length() - 1 && sql.charAt(i + 1) == '\"') {
                    ++i;
                } else {
                    boolean bl = inDoubleQuote = !inDoubleQuote;
                }
            }
            if (c != '?' || inSingleQuote || inDoubleQuote) continue;
            ++count;
        }
        return count;
    }
}

