/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.api.impl;

import com.databricks.jdbc.api.impl.DatabricksArray;
import com.databricks.jdbc.api.impl.DatabricksMap;
import com.databricks.jdbc.api.impl.MetadataParser;
import com.databricks.jdbc.exception.DatabricksDriverException;
import com.databricks.jdbc.log.JdbcLogger;
import com.databricks.jdbc.log.JdbcLoggerFactory;
import com.databricks.jdbc.model.telemetry.enums.DatabricksDriverErrorCode;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DatabricksStruct
implements Struct {
    private static final JdbcLogger LOGGER = JdbcLoggerFactory.getLogger(DatabricksStruct.class);
    private final Object[] attributes;
    private final String typeName;
    private final List<String> fieldNames;

    public DatabricksStruct(Map<String, Object> attributes, String metadata) {
        Map<String, String> typeMap = MetadataParser.parseStructMetadata(metadata);
        this.fieldNames = new ArrayList<String>(typeMap.keySet());
        this.attributes = this.convertAttributes(attributes, typeMap);
        this.typeName = metadata;
    }

    private Object[] convertAttributes(Map<String, Object> attributes, Map<String, String> typeMap) {
        Object[] convertedAttributes = new Object[typeMap.size()];
        int index = 0;
        for (String fieldName : this.fieldNames) {
            String fieldType = typeMap.get(fieldName);
            Object value = attributes.get(fieldName);
            if (fieldType.startsWith("STRUCT")) {
                if (value instanceof Map) {
                    convertedAttributes[index] = new DatabricksStruct((Map)value, fieldType);
                } else if (value instanceof DatabricksStruct) {
                    convertedAttributes[index] = value;
                } else {
                    this.throwConversionException("Map for STRUCT", value);
                }
            } else if (fieldType.startsWith("ARRAY")) {
                if (value instanceof List) {
                    convertedAttributes[index] = new DatabricksArray((List)value, fieldType);
                } else if (value instanceof DatabricksArray) {
                    convertedAttributes[index] = value;
                } else {
                    this.throwConversionException("List for ARRAY", value);
                }
            } else if (fieldType.startsWith("MAP")) {
                if (value instanceof Map) {
                    convertedAttributes[index] = new DatabricksMap((Map)value, fieldType);
                } else if (value instanceof DatabricksMap) {
                    convertedAttributes[index] = value;
                } else {
                    this.throwConversionException("Map for MAP", value);
                }
            } else {
                convertedAttributes[index] = this.convertSimpleValue(value, fieldType);
            }
            ++index;
        }
        return convertedAttributes;
    }

    private Object convertSimpleValue(Object value, String type) {
        if (value == null) {
            return null;
        }
        try {
            switch (type.toUpperCase()) {
                case "INT": {
                    return Integer.parseInt(value.toString());
                }
                case "BIGINT": {
                    return Long.parseLong(value.toString());
                }
                case "SHORT": {
                    return Short.parseShort(value.toString());
                }
                case "FLOAT": {
                    return Float.valueOf(Float.parseFloat(value.toString()));
                }
                case "DOUBLE": {
                    return Double.parseDouble(value.toString());
                }
                case "DECIMAL": {
                    return new BigDecimal(value.toString());
                }
                case "BOOLEAN": {
                    return Boolean.parseBoolean(value.toString());
                }
                case "DATE": {
                    return Date.valueOf(value.toString());
                }
                case "TIMESTAMP": {
                    return Timestamp.valueOf(value.toString());
                }
                case "TIME": {
                    return Time.valueOf(value.toString());
                }
                case "BINARY": {
                    return value instanceof byte[] ? value : (Object)value.toString().getBytes();
                }
            }
            return value.toString();
        }
        catch (Exception e) {
            String errorMessage = String.format("Failed to convert value %s to type %s", value, type);
            LOGGER.error(errorMessage);
            throw new DatabricksDriverException(errorMessage, DatabricksDriverErrorCode.COMPLEX_DATA_TYPE_STRUCT_CONVERSION_ERROR);
        }
    }

    @Override
    public String getSQLTypeName() throws SQLException {
        return this.typeName;
    }

    @Override
    public Object[] getAttributes() throws SQLException {
        return this.attributes;
    }

    @Override
    public Object[] getAttributes(Map<String, Class<?>> map) throws SQLException {
        return this.getAttributes();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        for (int i = 0; i < this.fieldNames.size(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append("\"").append(this.fieldNames.get(i)).append("\":");
            Object val = this.attributes[i];
            if (val == null) {
                sb.append("null");
                continue;
            }
            if (val instanceof String) {
                sb.append("\"").append(val).append("\"");
                continue;
            }
            sb.append(val);
        }
        sb.append("}");
        return sb.toString();
    }

    void throwConversionException(String datatype, Object value) {
        String errorMessage = String.format("Expected a %s but found: %s", datatype, value == null ? "null" : value.getClass().getSimpleName());
        LOGGER.error(errorMessage);
        throw new DatabricksDriverException(errorMessage, DatabricksDriverErrorCode.COMPLEX_DATA_TYPE_STRUCT_CONVERSION_ERROR);
    }
}

