/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.api.impl;

import com.databricks.internal.google.common.base.MoreObjects;
import com.databricks.internal.google.errorprone.annotations.CanIgnoreReturnValue;
import com.databricks.internal.sdk.service.sql.ColumnInfoTypeName;
import com.databricks.jdbc.api.impl.SqlParameter;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="SqlParameter", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableSqlParameter
implements SqlParameter {
    @Nullable
    private final Object value;
    private final ColumnInfoTypeName type;
    private final int cardinal;

    private ImmutableSqlParameter(@Nullable Object value, ColumnInfoTypeName type, int cardinal) {
        this.value = value;
        this.type = type;
        this.cardinal = cardinal;
    }

    @Override
    @Nullable
    public Object value() {
        return this.value;
    }

    @Override
    public ColumnInfoTypeName type() {
        return this.type;
    }

    @Override
    public int cardinal() {
        return this.cardinal;
    }

    public final ImmutableSqlParameter withValue(@Nullable Object value) {
        if (this.value == value) {
            return this;
        }
        return new ImmutableSqlParameter(value, this.type, this.cardinal);
    }

    public final ImmutableSqlParameter withType(ColumnInfoTypeName value) {
        ColumnInfoTypeName newValue = Objects.requireNonNull(value, "type");
        if (this.type == newValue) {
            return this;
        }
        return new ImmutableSqlParameter(this.value, newValue, this.cardinal);
    }

    public final ImmutableSqlParameter withCardinal(int value) {
        if (this.cardinal == value) {
            return this;
        }
        return new ImmutableSqlParameter(this.value, this.type, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSqlParameter && this.equalTo(0, (ImmutableSqlParameter)another);
    }

    private boolean equalTo(int synthetic, ImmutableSqlParameter another) {
        return Objects.equals(this.value, another.value) && this.type.equals((Object)another.type) && this.cardinal == another.cardinal;
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Objects.hashCode(this.value);
        h2 += (h2 << 5) + this.type.hashCode();
        h2 += (h2 << 5) + this.cardinal;
        return h2;
    }

    public String toString() {
        return MoreObjects.toStringHelper("SqlParameter").omitNullValues().add("value", this.value).add("type", (Object)this.type).add("cardinal", this.cardinal).toString();
    }

    public static ImmutableSqlParameter copyOf(SqlParameter instance) {
        if (instance instanceof ImmutableSqlParameter) {
            return (ImmutableSqlParameter)instance;
        }
        return ImmutableSqlParameter.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="SqlParameter", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long INIT_BIT_CARDINAL = 2L;
        private long initBits = 3L;
        @Nullable
        private Object value;
        @Nullable
        private ColumnInfoTypeName type;
        private int cardinal;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(SqlParameter instance) {
            Objects.requireNonNull(instance, "instance");
            Object valueValue = instance.value();
            if (valueValue != null) {
                this.value(valueValue);
            }
            this.type(instance.type());
            this.cardinal(instance.cardinal());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder value(@Nullable Object value) {
            this.value = value;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder type(ColumnInfoTypeName type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder cardinal(int cardinal) {
            this.cardinal = cardinal;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableSqlParameter build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSqlParameter(this.value, this.type, this.cardinal);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("type");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("cardinal");
            }
            return "Cannot build SqlParameter, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

