/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.api.impl.arrow;

import com.databricks.internal.apache.arrow.vector.ValueVector;
import com.databricks.internal.sdk.service.sql.ColumnInfo;
import com.databricks.internal.sdk.service.sql.ColumnInfoTypeName;
import com.databricks.jdbc.api.impl.arrow.AbstractArrowResultChunk;
import com.databricks.jdbc.api.impl.converters.ArrowToJavaObjectConverter;
import com.databricks.jdbc.exception.DatabricksSQLException;

public class ArrowResultChunkIterator {
    private final AbstractArrowResultChunk resultChunk;
    private final int recordBatchesInChunk;
    private int recordBatchCursorInChunk;
    private int rowsInRecordBatch;
    private int rowCursorInRecordBatch;
    private int rowsReadByIterator;

    ArrowResultChunkIterator(AbstractArrowResultChunk resultChunk) {
        this.resultChunk = resultChunk;
        this.recordBatchesInChunk = resultChunk.getRecordBatchCountInChunk();
        this.recordBatchCursorInChunk = -1;
        this.rowsInRecordBatch = -1;
        this.rowCursorInRecordBatch = -1;
        this.rowsReadByIterator = 0;
    }

    boolean nextRow() {
        if (!this.hasNextRow()) {
            return false;
        }
        if (this.rowsInRecordBatch < 0 || ++this.rowCursorInRecordBatch == this.rowsInRecordBatch) {
            this.rowCursorInRecordBatch = 0;
            ++this.recordBatchCursorInChunk;
            while (this.recordBatchCursorInChunk < this.recordBatchesInChunk && this.resultChunk.recordBatchList.get(this.recordBatchCursorInChunk).get(0).getValueCount() == 0) {
                ++this.recordBatchCursorInChunk;
            }
            this.rowsInRecordBatch = this.resultChunk.recordBatchList.get(this.recordBatchCursorInChunk).get(0).getValueCount();
        }
        ++this.rowsReadByIterator;
        return true;
    }

    boolean hasNextRow() {
        if ((long)this.rowsReadByIterator >= this.resultChunk.numRows) {
            return false;
        }
        return this.rowCursorInRecordBatch < this.rowsInRecordBatch - 1 || this.recordBatchCursorInChunk < this.recordBatchesInChunk - 1;
    }

    Object getColumnObjectAtCurrentRow(int columnIndex, ColumnInfoTypeName requiredType, String arrowMetadata, ColumnInfo columnInfo) throws DatabricksSQLException {
        ValueVector columnVector = this.resultChunk.getColumnVector(this.recordBatchCursorInChunk, columnIndex);
        return ArrowToJavaObjectConverter.convert(columnVector, this.rowCursorInRecordBatch, requiredType, arrowMetadata, columnInfo);
    }

    String getType(int columnIndex) {
        return this.resultChunk.getArrowMetadata().get(columnIndex);
    }
}

