/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.api.internal;

import com.databricks.internal.sdk.core.ProxyConfig;
import com.databricks.internal.sdk.core.utils.Cloud;
import com.databricks.jdbc.common.AuthFlow;
import com.databricks.jdbc.common.AuthMech;
import com.databricks.jdbc.common.CompressionCodec;
import com.databricks.jdbc.common.DatabricksClientType;
import com.databricks.jdbc.common.DatabricksJdbcUrlParams;
import com.databricks.jdbc.common.IDatabricksComputeResource;
import com.databricks.jdbc.common.LogLevel;
import com.databricks.jdbc.exception.DatabricksParsingException;
import java.util.List;
import java.util.Map;

public interface IDatabricksConnectionContext {
    public String getHostUrl() throws DatabricksParsingException;

    public IDatabricksComputeResource getComputeResource();

    public String getToken();

    public String getPassThroughAccessToken();

    public String getHostForOAuth();

    public String getClientId() throws DatabricksParsingException;

    public String getNullableClientId();

    public String getClientSecret();

    public List<String> getOAuthScopesForU2M() throws DatabricksParsingException;

    public AuthMech getAuthMech();

    public AuthFlow getAuthFlow();

    public boolean isPropertyPresent(DatabricksJdbcUrlParams var1);

    public LogLevel getLogLevel();

    public String getLogPathString();

    public int getLogFileSize();

    public int getLogFileCount();

    public String getClientUserAgent();

    public CompressionCodec getCompressionCodec();

    public String getCustomerUserAgent();

    public String getCatalog();

    public String getSchema();

    public Map<String, String> getSessionConfigs();

    public Map<String, String> getClientInfoProperties();

    public Map<String, String> getCustomHeaders();

    public boolean isAllPurposeCluster();

    public String getHttpPath();

    public String getProxyHost();

    public int getProxyPort();

    public String getProxyUser();

    public String getProxyPassword();

    public Boolean getUseProxy();

    public ProxyConfig.ProxyAuthType getProxyAuthType();

    public Boolean getUseSystemProxy();

    public Boolean getUseCloudFetchProxy();

    public Cloud getCloud() throws DatabricksParsingException;

    public String getCloudFetchProxyHost();

    public int getCloudFetchProxyPort();

    public String getCloudFetchProxyUser();

    public String getCloudFetchProxyPassword();

    public ProxyConfig.ProxyAuthType getCloudFetchProxyAuthType();

    public String getEndpointURL() throws DatabricksParsingException;

    public int getAsyncExecPollInterval();

    public Boolean shouldEnableArrow();

    public DatabricksClientType getClientType();

    public void setClientType(DatabricksClientType var1);

    public Boolean getUseEmptyMetadata();

    public int getCloudFetchThreadPoolSize();

    public double getCloudFetchSpeedThreshold();

    public Boolean getDirectResultMode();

    public Boolean shouldRetryTemporarilyUnavailableError();

    public Boolean shouldRetryRateLimitError();

    public int getTemporarilyUnavailableRetryTimeout();

    public int getRateLimitRetryTimeout();

    public int getIdleHttpConnectionExpiry();

    public boolean supportManyParameters();

    public String getConnectionURL();

    public boolean checkCertificateRevocation();

    public boolean acceptUndeterminedCertificateRevocation();

    public String getJWTKeyFile();

    public String getKID();

    public String getJWTPassphrase();

    public String getJWTAlgorithm();

    public boolean useJWTAssertion();

    public String getTokenEndpoint();

    public String getAuthEndpoint();

    public boolean isOAuthDiscoveryModeEnabled();

    public String getIdentityFederationClientId();

    public String getOAuthDiscoveryURL();

    public String getAuthScope();

    public String getOAuthRefreshToken();

    public List<Integer> getOAuth2RedirectUrlPorts();

    public String getGcpAuthType() throws DatabricksParsingException;

    public String getGoogleServiceAccount();

    public String getGoogleCredentials();

    public String getNonProxyHosts();

    public String getSSLTrustStore();

    public String getSSLTrustStorePassword();

    public String getSSLTrustStoreType();

    public String getSSLKeyStore();

    public String getSSLKeyStorePassword();

    public String getSSLKeyStoreType();

    public String getSSLKeyStoreProvider();

    public String getSSLTrustStoreProvider();

    public int getMaxBatchSize();

    public boolean isTelemetryEnabled();

    public int getTelemetryBatchSize();

    public String getConnectionUuid();

    public String getVolumeOperationAllowedPaths();

    public boolean isSqlExecHybridResultsEnabled();

    public String getAzureTenantId();

    public boolean isRequestTracingEnabled();

    public int getDefaultStringColumnLength();

    public boolean isComplexDatatypeSupportEnabled();

    public int getHttpConnectionPoolSize();

    public List<Integer> getUCIngestionRetriableHttpCodes();

    public int getUCIngestionRetryTimeoutSeconds();

    public String getAzureWorkspaceResourceId();

    public int getRowsFetchedPerBlock();

    public int getSocketTimeout();

    public boolean allowSelfSignedCerts();

    public boolean useSystemTrustStore();

    public String getTokenCachePassPhrase();

    public boolean isTokenCacheEnabled();

    public int getMaxDBFSConcurrentPresignedRequests();

    public String getApplicationName();

    public int getChunkReadyTimeoutSeconds();

    public boolean forceEnableTelemetry();

    public int getTelemetryFlushIntervalInMilliseconds();
}

