/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.auth;

import com.databricks.internal.apache.http.client.methods.CloseableHttpResponse;
import com.databricks.internal.apache.http.client.methods.HttpGet;
import com.databricks.internal.apache.http.client.utils.URIBuilder;
import com.databricks.internal.sdk.core.DatabricksException;
import com.databricks.internal.sdk.core.oauth.OAuthResponse;
import com.databricks.internal.sdk.core.oauth.RefreshableTokenSource;
import com.databricks.internal.sdk.core.oauth.Token;
import com.databricks.jdbc.common.util.JsonUtil;
import com.databricks.jdbc.dbclient.IDatabricksHttpClient;
import com.databricks.jdbc.exception.DatabricksHttpException;
import com.databricks.jdbc.log.JdbcLogger;
import com.databricks.jdbc.log.JdbcLoggerFactory;
import java.io.IOException;
import java.net.URISyntaxException;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;

public class AzureMSICredentials
extends RefreshableTokenSource {
    private static final JdbcLogger LOGGER = JdbcLoggerFactory.getLogger(AzureMSICredentials.class);
    private static final String AZURE_METADATA_SERVICE_TOKEN_URL = "http://169.254.169.254/metadata/identity/oauth2/token";
    private static final String API_VERSION = "2021-10-01";
    private static final String AZURE_DATABRICKS_SCOPE = "2ff814a6-3304-4ab8-85cb-cd0e6f879c1d";
    private static final String AZURE_MANAGEMENT_ENDPOINT = "https://management.core.windows.net/";
    private final IDatabricksHttpClient hc;
    private final String clientId;

    AzureMSICredentials(IDatabricksHttpClient hc, String clientId) {
        this.hc = hc;
        this.clientId = clientId;
    }

    @Override
    protected Token refresh() {
        return this.getTokenForResource(AZURE_DATABRICKS_SCOPE);
    }

    public Token getManagementEndpointToken() {
        return this.getTokenForResource(AZURE_MANAGEMENT_ENDPOINT);
    }

    private Token getTokenForResource(String resource) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("api-version", API_VERSION);
        params.put("resource", resource);
        if (this.clientId != null) {
            LOGGER.debug("Attempting to connect via Azure user-assigned managed identity with client ID: {}", this.clientId);
            params.put("client_id", this.clientId);
        } else {
            LOGGER.debug("Attempting to connect via Azure system-assigned managed identity");
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Metadata", "true");
        return AzureMSICredentials.retrieveToken(this.hc, AZURE_METADATA_SERVICE_TOKEN_URL, params, headers);
    }

    private static Token retrieveToken(IDatabricksHttpClient hc, String tokenUrl, Map<String, String> params, Map<String, String> headers) {
        try {
            URIBuilder uriBuilder = new URIBuilder(tokenUrl);
            params.forEach(uriBuilder::addParameter);
            HttpGet getRequest = new HttpGet(uriBuilder.build());
            headers.forEach(getRequest::setHeader);
            LOGGER.debug("Executing GET request to retrieve Azure MSI token");
            CloseableHttpResponse response = hc.execute(getRequest);
            OAuthResponse resp = JsonUtil.getMapper().readValue(response.getEntity().getContent(), OAuthResponse.class);
            LocalDateTime expiry = LocalDateTime.now().plus(resp.getExpiresIn(), ChronoUnit.SECONDS);
            LOGGER.debug("Azure MSI Token retrieved successfully");
            return new Token(resp.getAccessToken(), resp.getTokenType(), resp.getRefreshToken(), expiry);
        }
        catch (DatabricksHttpException | IOException | URISyntaxException e) {
            String errorMessage = "Failed to retrieve Azure MSI token: " + e.getMessage();
            LOGGER.error(errorMessage);
            throw new DatabricksException(errorMessage, e);
        }
    }
}

