/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.auth;

import com.databricks.internal.sdk.core.CredentialsProvider;
import com.databricks.internal.sdk.core.DatabricksConfig;
import com.databricks.internal.sdk.core.DatabricksException;
import com.databricks.internal.sdk.core.HeaderFactory;
import com.databricks.internal.sdk.core.http.HttpClient;
import com.databricks.internal.sdk.core.oauth.AuthParameterPosition;
import com.databricks.internal.sdk.core.oauth.RefreshableTokenSource;
import com.databricks.internal.sdk.core.oauth.Token;
import com.databricks.jdbc.api.internal.IDatabricksConnectionContext;
import com.databricks.jdbc.common.util.DatabricksAuthUtil;
import com.databricks.jdbc.exception.DatabricksParsingException;
import com.databricks.jdbc.log.JdbcLogger;
import com.databricks.jdbc.log.JdbcLoggerFactory;
import java.lang.invoke.CallSite;
import java.time.LocalDateTime;
import java.util.HashMap;

public class OAuthRefreshCredentialsProvider
extends RefreshableTokenSource
implements CredentialsProvider {
    private static final JdbcLogger LOGGER = JdbcLoggerFactory.getLogger(OAuthRefreshCredentialsProvider.class);
    private HttpClient hc;
    private final String tokenEndpoint;
    private final String clientId;
    private final String clientSecret;

    public OAuthRefreshCredentialsProvider(IDatabricksConnectionContext context, DatabricksConfig databricksConfig) {
        this.tokenEndpoint = DatabricksAuthUtil.getTokenEndpoint(databricksConfig, context);
        try {
            this.clientId = context.getClientId();
        }
        catch (DatabricksParsingException e) {
            String exceptionMessage = "Failed to parse client id";
            LOGGER.error(exceptionMessage);
            throw new DatabricksException(exceptionMessage, e);
        }
        this.clientSecret = context.getClientSecret();
        this.token = new Token("", "", context.getOAuthRefreshToken(), LocalDateTime.now().minusMinutes(1L));
    }

    @Override
    public String authType() {
        return "oauth-refresh";
    }

    @Override
    public HeaderFactory configure(DatabricksConfig databricksConfig) {
        if (this.hc == null) {
            this.hc = databricksConfig.getHttpClient();
        }
        return () -> {
            HashMap<String, CallSite> headers = new HashMap<String, CallSite>();
            headers.put("Authorization", (CallSite)((Object)(this.getToken().getTokenType() + " " + this.getToken().getAccessToken())));
            return headers;
        };
    }

    @Override
    protected Token refresh() {
        if (this.token == null) {
            String exceptionMessage = "oauth2: token is not set";
            LOGGER.error(exceptionMessage);
            throw new DatabricksException(exceptionMessage);
        }
        String refreshToken = this.token.getRefreshToken();
        if (refreshToken == null) {
            String exceptionMessage = "oauth2: token expired and refresh token is not set";
            LOGGER.error(exceptionMessage);
            throw new DatabricksException(exceptionMessage);
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("grant_type", "refresh_token");
        params.put("refresh_token", refreshToken);
        HashMap<String, String> headers = new HashMap<String, String>();
        return OAuthRefreshCredentialsProvider.retrieveToken(this.hc, this.clientId, this.clientSecret, this.tokenEndpoint, params, headers, AuthParameterPosition.BODY);
    }
}

