/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.common.safe;

import com.databricks.internal.google.common.annotations.VisibleForTesting;
import com.databricks.jdbc.api.internal.IDatabricksConnectionContext;
import com.databricks.jdbc.common.safe.DatabricksDriverFeatureFlagsContext;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DatabricksDriverFeatureFlagsContextFactory {
    private static final Map<String, DatabricksDriverFeatureFlagsContext> contextMap = new ConcurrentHashMap<String, DatabricksDriverFeatureFlagsContext>();

    private DatabricksDriverFeatureFlagsContextFactory() {
    }

    public static DatabricksDriverFeatureFlagsContext getInstance(IDatabricksConnectionContext context) {
        return contextMap.computeIfAbsent(context.getComputeResource().getUniqueIdentifier(), k -> new DatabricksDriverFeatureFlagsContext(context));
    }

    public static void removeInstance(IDatabricksConnectionContext connectionContext) {
        if (connectionContext != null) {
            contextMap.remove(connectionContext.getComputeResource().getUniqueIdentifier());
        }
    }

    @VisibleForTesting
    static void setFeatureFlagsContext(IDatabricksConnectionContext connectionContext, Map<String, String> featureFlags) {
        contextMap.put(connectionContext.getComputeResource().getUniqueIdentifier(), new DatabricksDriverFeatureFlagsContext(connectionContext, featureFlags));
    }
}

