/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.common.util;

import com.databricks.internal.apache.arrow.vector.types.DateUnit;
import com.databricks.internal.apache.arrow.vector.types.FloatingPointPrecision;
import com.databricks.internal.apache.arrow.vector.types.TimeUnit;
import com.databricks.internal.apache.arrow.vector.types.pojo.ArrowType;
import com.databricks.internal.sdk.service.sql.ColumnInfoTypeName;
import com.databricks.jdbc.api.internal.IDatabricksConnectionContext;
import com.databricks.jdbc.common.Nullable;
import com.databricks.jdbc.exception.DatabricksSQLFeatureNotSupportedException;
import com.databricks.jdbc.log.JdbcLogger;
import com.databricks.jdbc.log.JdbcLoggerFactory;
import com.databricks.jdbc.model.client.thrift.generated.TPrimitiveTypeEntry;
import com.databricks.jdbc.model.client.thrift.generated.TTypeDesc;
import com.databricks.jdbc.model.client.thrift.generated.TTypeEntry;
import com.databricks.jdbc.model.client.thrift.generated.TTypeId;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;

public class DatabricksTypeUtil {
    private static final JdbcLogger LOGGER = JdbcLoggerFactory.getLogger(DatabricksTypeUtil.class);
    public static final String BIGINT = "BIGINT";
    public static final String LONG = "LONG";
    public static final String BINARY = "BINARY";
    public static final String BOOLEAN = "BOOLEAN";
    public static final String DATE = "DATE";
    public static final String DECIMAL = "DECIMAL";
    public static final String DOUBLE = "DOUBLE";
    public static final String FLOAT = "FLOAT";
    public static final String INT = "INT";
    public static final String BYTE = "BYTE";
    public static final String VOID = "VOID";
    public static final String SMALLINT = "SHORT";
    public static final String NULL = "NULL";
    public static final String STRING = "STRING";
    public static final String TINYINT = "TINYINT";
    public static final String TIMESTAMP = "TIMESTAMP";
    public static final String TIME = "TIME";
    public static final String TIMESTAMP_NTZ = "TIMESTAMP_NTZ";
    public static final String MAP = "MAP";
    public static final String ARRAY = "ARRAY";
    public static final String STRUCT = "STRUCT";
    public static final String VARIANT = "VARIANT";
    public static final String CHAR = "CHAR";
    public static final String INTERVAL = "INTERVAL";
    private static final ArrayList<ColumnInfoTypeName> SIGNED_TYPES = new ArrayList<ColumnInfoTypeName>(Arrays.asList(ColumnInfoTypeName.DECIMAL, ColumnInfoTypeName.DOUBLE, ColumnInfoTypeName.FLOAT, ColumnInfoTypeName.INT, ColumnInfoTypeName.LONG, ColumnInfoTypeName.SHORT));

    public static ColumnInfoTypeName getColumnInfoType(String typeName) {
        switch (typeName) {
            case "CHAR": 
            case "STRING": {
                return ColumnInfoTypeName.STRING;
            }
            case "DATE": 
            case "TIMESTAMP": 
            case "TIMESTAMP_NTZ": {
                return ColumnInfoTypeName.TIMESTAMP;
            }
            case "SHORT": 
            case "TINYINT": {
                return ColumnInfoTypeName.SHORT;
            }
            case "BYTE": {
                return ColumnInfoTypeName.BYTE;
            }
            case "INT": {
                return ColumnInfoTypeName.INT;
            }
            case "BIGINT": 
            case "LONG": {
                return ColumnInfoTypeName.LONG;
            }
            case "FLOAT": {
                return ColumnInfoTypeName.FLOAT;
            }
            case "DOUBLE": {
                return ColumnInfoTypeName.DOUBLE;
            }
            case "BINARY": {
                return ColumnInfoTypeName.BINARY;
            }
            case "BOOLEAN": {
                return ColumnInfoTypeName.BOOLEAN;
            }
            case "DECIMAL": {
                return ColumnInfoTypeName.DECIMAL;
            }
            case "STRUCT": {
                return ColumnInfoTypeName.STRUCT;
            }
            case "ARRAY": {
                return ColumnInfoTypeName.ARRAY;
            }
            case "VOID": 
            case "NULL": {
                return ColumnInfoTypeName.NULL;
            }
            case "MAP": {
                return ColumnInfoTypeName.MAP;
            }
        }
        return ColumnInfoTypeName.USER_DEFINED_TYPE;
    }

    public static int getColumnType(ColumnInfoTypeName typeName) {
        if (typeName == null) {
            return 1111;
        }
        switch (typeName) {
            case BYTE: {
                return -6;
            }
            case SHORT: {
                return 5;
            }
            case INT: {
                return 4;
            }
            case LONG: {
                return -5;
            }
            case FLOAT: {
                return 6;
            }
            case DOUBLE: {
                return 8;
            }
            case DECIMAL: {
                return 3;
            }
            case BINARY: {
                return -2;
            }
            case BOOLEAN: {
                return 16;
            }
            case CHAR: {
                return 1;
            }
            case STRING: 
            case MAP: 
            case INTERVAL: 
            case NULL: {
                return 12;
            }
            case TIMESTAMP: {
                return 93;
            }
            case DATE: {
                return 91;
            }
            case STRUCT: {
                return 2002;
            }
            case ARRAY: {
                return 2003;
            }
            case USER_DEFINED_TYPE: {
                return 1111;
            }
        }
        String errorMsg = "Unknown column type: " + String.valueOf((Object)typeName);
        LOGGER.error(errorMsg);
        throw new IllegalStateException(errorMsg);
    }

    public static String getColumnTypeClassName(ColumnInfoTypeName typeName) {
        if (typeName == null) {
            return "null";
        }
        switch (typeName) {
            case BYTE: 
            case SHORT: 
            case INT: {
                return "java.lang.Integer";
            }
            case LONG: {
                return "java.lang.Long";
            }
            case FLOAT: {
                return "java.lang.Float";
            }
            case DOUBLE: {
                return "java.lang.Double";
            }
            case DECIMAL: {
                return "java.math.BigDecimal";
            }
            case BINARY: {
                return "[B";
            }
            case BOOLEAN: {
                return "java.lang.Boolean";
            }
            case CHAR: 
            case STRING: 
            case INTERVAL: 
            case USER_DEFINED_TYPE: {
                return "java.lang.String";
            }
            case TIMESTAMP: {
                return "java.sql.Timestamp";
            }
            case DATE: {
                return "java.sql.Date";
            }
            case STRUCT: {
                return "java.sql.Struct";
            }
            case ARRAY: {
                return "java.sql.Array";
            }
            case NULL: {
                return "null";
            }
            case MAP: {
                return "java.util.Map";
            }
        }
        String errorMsg = "Unknown column type class name: " + String.valueOf((Object)typeName);
        LOGGER.error(errorMsg);
        throw new IllegalStateException(errorMsg);
    }

    public static int[] getBasePrecisionAndScale(int columnType, IDatabricksConnectionContext ctx) {
        if (columnType == 12 || columnType == 1) {
            return new int[]{ctx.getDefaultStringColumnLength(), 0};
        }
        return new int[]{DatabricksTypeUtil.getPrecision(columnType), DatabricksTypeUtil.getScale(columnType)};
    }

    private static int calculateDisplaySize(int scale, int precision) {
        return scale == precision ? precision + 3 : (scale == 0 ? precision + 1 : precision + 2);
    }

    public static int getDisplaySize(ColumnInfoTypeName typeName, int precision, int scale) {
        if (typeName == null) {
            return 255;
        }
        switch (typeName) {
            case BYTE: {
                return 4;
            }
            case SHORT: 
            case INT: 
            case LONG: 
            case BINARY: {
                return precision + 1;
            }
            case CHAR: 
            case STRING: {
                return precision;
            }
            case FLOAT: {
                return 14;
            }
            case DOUBLE: {
                return 24;
            }
            case DECIMAL: {
                return DatabricksTypeUtil.calculateDisplaySize(scale, precision);
            }
            case BOOLEAN: {
                return 1;
            }
            case TIMESTAMP: {
                return 29;
            }
            case DATE: {
                return 10;
            }
            case NULL: {
                return 4;
            }
        }
        return 255;
    }

    public static int getDisplaySize(int sqlType, int precision) {
        switch (sqlType) {
            case 4: 
            case 5: {
                return precision + 1;
            }
            case 1: {
                return precision;
            }
            case 16: {
                return 5;
            }
            case -7: {
                return 1;
            }
            case 12: {
                return 128;
            }
        }
        return 255;
    }

    public static int getMetadataColPrecision(Integer columnType) {
        switch (columnType) {
            case 5: {
                return 5;
            }
            case 4: {
                return 10;
            }
            case -7: 
            case 1: 
            case 16: {
                return 1;
            }
            case 12: {
                return 128;
            }
        }
        return 255;
    }

    public static int getPrecision(Integer columnType) {
        if (columnType == null) {
            return 0;
        }
        switch (columnType) {
            case -6: {
                return 3;
            }
            case 5: {
                return 5;
            }
            case 3: 
            case 4: 
            case 91: {
                return 10;
            }
            case -5: {
                return 19;
            }
            case -2: 
            case 1: 
            case 16: {
                return 1;
            }
            case 6: {
                return 7;
            }
            case 8: {
                return 15;
            }
            case 93: {
                return 29;
            }
        }
        return 255;
    }

    public static int getScale(Integer columnType) {
        if (columnType == null) {
            return 0;
        }
        return columnType == 93 ? 9 : 0;
    }

    public static boolean isSigned(ColumnInfoTypeName typeName) {
        return SIGNED_TYPES.contains((Object)typeName);
    }

    public static Nullable getNullableFromValue(Integer isNullable) {
        if (isNullable == null) {
            return Nullable.UNKNOWN;
        }
        if (isNullable == 0) {
            return Nullable.NO_NULLS;
        }
        if (isNullable == 1) {
            return Nullable.NULLABLE;
        }
        return Nullable.UNKNOWN;
    }

    public static String getDatabricksTypeFromSQLType(int sqlType) {
        switch (sqlType) {
            case 1: {
                return CHAR;
            }
            case 2003: {
                return ARRAY;
            }
            case -5: {
                return LONG;
            }
            case -4: 
            case -3: 
            case -2: {
                return BINARY;
            }
            case 91: {
                return DATE;
            }
            case 2: 
            case 3: {
                return DECIMAL;
            }
            case -7: 
            case 16: {
                return BOOLEAN;
            }
            case 8: {
                return DOUBLE;
            }
            case 6: 
            case 7: {
                return FLOAT;
            }
            case 4: {
                return INT;
            }
            case -16: 
            case -9: 
            case -1: 
            case 12: {
                return STRING;
            }
            case 93: {
                return TIMESTAMP_NTZ;
            }
            case 2014: {
                return TIMESTAMP;
            }
            case 2002: {
                return STRUCT;
            }
            case -6: {
                return TINYINT;
            }
            case 5: {
                return SMALLINT;
            }
        }
        return NULL;
    }

    public static String inferDatabricksType(Object obj) {
        String type = null;
        if (obj == null) {
            type = VOID;
        } else if (obj instanceof Long) {
            type = BIGINT;
        } else if (obj instanceof Short) {
            type = SMALLINT;
        } else if (obj instanceof Byte) {
            type = TINYINT;
        } else if (obj instanceof Float) {
            type = FLOAT;
        } else if (obj instanceof String) {
            type = STRING;
        } else if (obj instanceof Integer) {
            type = INT;
        } else if (obj instanceof Timestamp) {
            type = TIMESTAMP;
        } else if (obj instanceof Date) {
            type = DATE;
        } else if (obj instanceof Double) {
            type = DOUBLE;
        }
        return type;
    }

    public static TPrimitiveTypeEntry getTPrimitiveTypeOrDefault(TTypeDesc typeDesc) {
        TPrimitiveTypeEntry defaultPrimitiveTypeEntry = new TPrimitiveTypeEntry(TTypeId.STRING_TYPE);
        return Optional.ofNullable(typeDesc).map(TTypeDesc::getTypes).map(t2 -> (TTypeEntry)t2.get(0)).map(TTypeEntry::getPrimitiveEntry).orElse(defaultPrimitiveTypeEntry);
    }

    public static ArrowType mapThriftToArrowType(TTypeId typeId) throws SQLException {
        switch (typeId) {
            case BOOLEAN_TYPE: {
                return ArrowType.Bool.INSTANCE;
            }
            case TINYINT_TYPE: {
                return new ArrowType.Int(8, true);
            }
            case SMALLINT_TYPE: {
                return new ArrowType.Int(16, true);
            }
            case INT_TYPE: {
                return new ArrowType.Int(32, true);
            }
            case BIGINT_TYPE: {
                return new ArrowType.Int(64, true);
            }
            case FLOAT_TYPE: {
                return new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE);
            }
            case DOUBLE_TYPE: {
                return new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE);
            }
            case INTERVAL_DAY_TIME_TYPE: 
            case INTERVAL_YEAR_MONTH_TYPE: 
            case STRING_TYPE: 
            case ARRAY_TYPE: 
            case MAP_TYPE: 
            case STRUCT_TYPE: 
            case USER_DEFINED_TYPE: 
            case DECIMAL_TYPE: 
            case UNION_TYPE: 
            case VARCHAR_TYPE: 
            case CHAR_TYPE: {
                return ArrowType.Utf8.INSTANCE;
            }
            case TIMESTAMP_TYPE: {
                return new ArrowType.Timestamp(TimeUnit.MICROSECOND, null);
            }
            case BINARY_TYPE: {
                return ArrowType.Binary.INSTANCE;
            }
            case DATE_TYPE: {
                return new ArrowType.Date(DateUnit.DAY);
            }
            case NULL_TYPE: {
                return ArrowType.Null.INSTANCE;
            }
        }
        throw new DatabricksSQLFeatureNotSupportedException("Unsupported mapping of Thrift to ArrowType: " + String.valueOf(typeId));
    }

    public static String getDecimalTypeString(BigDecimal bd) {
        int scale;
        int precision = bd.precision();
        if (precision < (scale = bd.scale())) {
            precision = scale;
        }
        return "DECIMAL(" + precision + "," + scale + ")";
    }
}

