/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.common.util;

import com.databricks.internal.sdk.service.sql.ColumnInfoTypeName;
import com.databricks.jdbc.api.impl.ImmutableSqlParameter;
import com.databricks.jdbc.common.MetadataResultConstants;
import com.databricks.jdbc.exception.DatabricksValidationException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SQLInterpolator {
    private static String escapeApostrophes(String input) {
        if (input == null) {
            return null;
        }
        return input.replace("'", "''");
    }

    private static String formatObject(ImmutableSqlParameter object) {
        if (object == null || object.value() == null) {
            return MetadataResultConstants.NULL_STRING;
        }
        if (object.type() == ColumnInfoTypeName.BINARY) {
            return object.value().toString();
        }
        if (object.value() instanceof String) {
            return "'" + SQLInterpolator.escapeApostrophes((String)object.value()) + "'";
        }
        return object.value().toString();
    }

    private static int countPlaceholders(String sql) {
        int count = 0;
        for (char c : sql.toCharArray()) {
            if (c != '?') continue;
            ++count;
        }
        return count;
    }

    public static String interpolateSQL(String sql, Map<Integer, ImmutableSqlParameter> params) throws DatabricksValidationException {
        String[] parts = sql.split("\\?");
        if (SQLInterpolator.countPlaceholders(sql) != params.size()) {
            throw new DatabricksValidationException("Parameter count does not match. Provide equal number of parameters as placeholders. SQL " + sql);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < parts.length; ++i) {
            sb.append(parts[i]);
            if (i >= params.size()) continue;
            sb.append(SQLInterpolator.formatObject(params.get(i + 1)));
        }
        return sb.toString();
    }

    public static String surroundPlaceholdersWithQuotes(String sql) {
        if (sql == null || sql.isEmpty()) {
            return sql;
        }
        StringBuilder sb = new StringBuilder();
        Matcher m4 = Pattern.compile("(?<!')\\?(?!')").matcher(sql);
        while (m4.find()) {
            m4.appendReplacement(sb, "'?'");
        }
        m4.appendTail(sb);
        return sb.toString();
    }
}

