/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.common.util;

import com.databricks.internal.sdk.core.UserAgent;
import com.databricks.jdbc.api.internal.IDatabricksConnectionContext;
import com.databricks.jdbc.common.util.DriverUtil;
import com.databricks.jdbc.common.util.WildcardUtil;
import com.databricks.jdbc.telemetry.TelemetryHelper;

public class UserAgentManager {
    private static final String SDK_USER_AGENT = "databricks-sdk-java";
    private static final String JDBC_HTTP_USER_AGENT = "databricks-jdbc-http";
    private static final String DEFAULT_USER_AGENT = "DatabricksJDBCDriverOSS";
    private static final String CLIENT_USER_AGENT_PREFIX = "Java";
    public static final String USER_AGENT_SEA_CLIENT = "SQLExecHttpClient";
    public static final String USER_AGENT_THRIFT_CLIENT = "THttpClient";
    private static final String APP_NAME_SYSTEM_PROPERTY = "app.name";
    private static final String VERSION_FILLER = "version";

    public static void setUserAgent(IDatabricksConnectionContext connectionContext) {
        UserAgent.withProduct(DEFAULT_USER_AGENT, DriverUtil.getDriverVersion());
        UserAgent.withOtherInfo(CLIENT_USER_AGENT_PREFIX, connectionContext.getClientUserAgent());
        UserAgentManager.updateUserAgentAndTelemetry(connectionContext, null);
    }

    static String determineApplicationName(IDatabricksConnectionContext connectionContext, String clientInfoAppName) {
        String appName = connectionContext.getCustomerUserAgent();
        if (!WildcardUtil.isNullOrEmpty(appName)) {
            return appName;
        }
        appName = connectionContext.getApplicationName();
        if (!WildcardUtil.isNullOrEmpty(appName)) {
            return appName;
        }
        if (!WildcardUtil.isNullOrEmpty(clientInfoAppName)) {
            return clientInfoAppName;
        }
        return System.getProperty(APP_NAME_SYSTEM_PROPERTY);
    }

    public static void updateUserAgentAndTelemetry(IDatabricksConnectionContext connectionContext, String clientInfoAppName) {
        String appName = UserAgentManager.determineApplicationName(connectionContext, clientInfoAppName);
        if (!WildcardUtil.isNullOrEmpty(appName)) {
            TelemetryHelper.updateClientAppName(appName);
            int i = appName.indexOf(47);
            String customerName = i < 0 ? appName : appName.substring(0, i);
            String customerVersion = i < 0 ? VERSION_FILLER : appName.substring(i + 1);
            UserAgent.withOtherInfo(customerName, UserAgent.sanitize(customerVersion));
        }
    }

    public static String getUserAgentString() {
        String sdkUserAgent = UserAgent.asString();
        String[] parts = sdkUserAgent.split("\\s+");
        StringBuilder mergedString = new StringBuilder();
        for (int i = 0; i < parts.length; ++i) {
            if (parts[i].startsWith(SDK_USER_AGENT)) {
                mergedString.append(JDBC_HTTP_USER_AGENT);
            } else {
                mergedString.append(parts[i]);
            }
            if (i == parts.length - 1) continue;
            mergedString.append(" ");
        }
        return mergedString.toString();
    }
}

