/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.dbclient.impl.common;

import com.databricks.jdbc.common.DatabricksClientType;
import com.databricks.jdbc.dbclient.impl.thrift.ResourceId;
import com.databricks.jdbc.exception.DatabricksDriverException;
import com.databricks.jdbc.log.JdbcLogger;
import com.databricks.jdbc.log.JdbcLoggerFactory;
import com.databricks.jdbc.model.client.thrift.generated.THandleIdentifier;
import com.databricks.jdbc.model.telemetry.enums.DatabricksDriverErrorCode;
import java.util.Objects;

public class StatementId {
    private static final JdbcLogger LOGGER = JdbcLoggerFactory.getLogger(StatementId.class);
    final DatabricksClientType clientType;
    final String guid;
    final String secret;

    StatementId(DatabricksClientType clientType, String guid, String secret) {
        this.clientType = clientType;
        this.guid = guid;
        this.secret = secret;
    }

    public StatementId(String statementId) {
        this(DatabricksClientType.SEA, statementId, null);
    }

    public StatementId(THandleIdentifier identifier) {
        this(DatabricksClientType.THRIFT, ResourceId.fromBytes(identifier.getGuid()).toString(), ResourceId.fromBytes(identifier.getSecret()).toString());
    }

    public static StatementId deserialize(String serializedStatementId) {
        String[] idParts = serializedStatementId.split("\\|");
        if (idParts.length == 1) {
            return new StatementId(DatabricksClientType.SEA, serializedStatementId, null);
        }
        if (idParts.length == 2) {
            return new StatementId(DatabricksClientType.THRIFT, idParts[0], idParts[1]);
        }
        LOGGER.error("Invalid statement-Id {}", serializedStatementId);
        throw new DatabricksDriverException("Invalid statement-Id " + serializedStatementId, DatabricksDriverErrorCode.INPUT_VALIDATION_ERROR);
    }

    public String toString() {
        switch (this.clientType) {
            case SEA: {
                return this.guid;
            }
            case THRIFT: {
                return String.format("%s|%s", this.guid, this.secret);
            }
        }
        return this.guid;
    }

    public THandleIdentifier toOperationIdentifier() {
        if (this.clientType.equals((Object)DatabricksClientType.SEA)) {
            return null;
        }
        return new THandleIdentifier().setGuid(ResourceId.fromBase64(this.guid).toBytes()).setSecret(ResourceId.fromBase64(this.secret).toBytes());
    }

    public String toSQLExecStatementId() {
        return this.guid;
    }

    public boolean equals(Object otherStatement) {
        if (!(otherStatement instanceof StatementId) || this.clientType != ((StatementId)otherStatement).clientType) {
            return false;
        }
        return Objects.equals(this.guid, ((StatementId)otherStatement).guid) && Objects.equals(this.secret, ((StatementId)otherStatement).secret);
    }
}

