/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.dbclient.impl.http;

import com.databricks.internal.apache.hc.client5.http.HttpRoute;
import com.databricks.internal.apache.hc.client5.http.impl.DefaultSchemePortResolver;
import com.databricks.internal.apache.hc.client5.http.impl.IdleConnectionEvictor;
import com.databricks.internal.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import com.databricks.internal.apache.hc.client5.http.impl.async.HttpAsyncClientBuilder;
import com.databricks.internal.apache.hc.client5.http.impl.async.HttpAsyncClients;
import com.databricks.internal.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManager;
import com.databricks.internal.apache.hc.core5.http.HttpException;
import com.databricks.internal.apache.hc.core5.http.HttpHost;
import com.databricks.internal.apache.hc.core5.io.CloseMode;
import com.databricks.internal.apache.hc.core5.reactor.IOReactorConfig;
import com.databricks.internal.apache.hc.core5.util.TimeValue;
import com.databricks.jdbc.common.util.DriverUtil;
import com.databricks.jdbc.log.JdbcLogger;
import com.databricks.jdbc.log.JdbcLoggerFactory;
import java.io.Closeable;
import java.net.URISyntaxException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class GlobalAsyncHttpClient {
    private static final JdbcLogger LOGGER = JdbcLoggerFactory.getLogger(GlobalAsyncHttpClient.class);
    private static volatile GlobalAsyncHttpClientHolder instance;
    private static final Object LOCK;

    private GlobalAsyncHttpClient() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CloseableHttpAsyncClient getClient() {
        GlobalAsyncHttpClientHolder holder = instance;
        if (holder == null) {
            Object object = LOCK;
            synchronized (object) {
                holder = instance;
                if (holder == null) {
                    instance = holder = new GlobalAsyncHttpClientHolder();
                }
            }
        }
        holder.incrementReference();
        return holder.getClient();
    }

    public static void releaseClient() {
        GlobalAsyncHttpClientHolder holder = instance;
        if (holder != null) {
            holder.decrementReference();
        }
    }

    static {
        LOCK = new Object();
    }

    private static class GlobalAsyncHttpClientHolder
    implements Closeable {
        static final int MAX_TOTAL_CONNECTIONS = 2500;
        static final int MAX_CONNECTIONS_PER_ROUTE = 1000;
        static final int EVICTION_CHECK_INTERVAL_SECONDS = 60;
        static final int IDLE_CONNECTION_TIMEOUT_SECONDS = 180;
        static final int IO_THREADS_COUNT = Math.max(Runtime.getRuntime().availableProcessors() * 2, 8);
        private final CloseableHttpAsyncClient client;
        private final PoolingAsyncClientConnectionManager connectionManager;
        private final IdleConnectionEvictor connectionEvictor;
        private final AtomicInteger referenceCount;

        GlobalAsyncHttpClientHolder() {
            LOGGER.info("Initializing global async HTTP client");
            this.referenceCount = new AtomicInteger(0);
            IOReactorConfig ioReactorConfig = IOReactorConfig.custom().setIoThreadCount(IO_THREADS_COUNT).build();
            this.connectionManager = new PoolingAsyncClientConnectionManager();
            this.connectionManager.setMaxTotal(2500);
            this.connectionManager.setDefaultMaxPerRoute(1000);
            HttpAsyncClientBuilder builder = HttpAsyncClients.custom().setIOReactorConfig(ioReactorConfig).setConnectionManager(this.connectionManager);
            if (DriverUtil.isRunningAgainstFake()) {
                this.setFakeServiceRouteInAsyncHttpClient(builder);
            }
            this.client = builder.build();
            this.client.start();
            this.connectionEvictor = new IdleConnectionEvictor(this.connectionManager, TimeValue.of(60L, TimeUnit.SECONDS), TimeValue.of(180L, TimeUnit.SECONDS));
            this.connectionEvictor.start();
        }

        private void setFakeServiceRouteInAsyncHttpClient(HttpAsyncClientBuilder builder) {
            builder.setRoutePlanner((host, context) -> {
                HttpHost proxy;
                HttpHost target = new HttpHost(host.getSchemeName(), host.getHostName(), DefaultSchemePortResolver.INSTANCE.resolve(host));
                if ("localhost".equalsIgnoreCase(host.getHostName())) {
                    return new HttpRoute(target, null, false);
                }
                try {
                    proxy = HttpHost.create(System.getProperty(host.toURI() + ".fakeServiceURI"));
                }
                catch (URISyntaxException e) {
                    throw new HttpException(e.getMessage());
                }
                return new HttpRoute(target, null, proxy, false);
            });
        }

        CloseableHttpAsyncClient getClient() {
            return this.client;
        }

        void incrementReference() {
            this.referenceCount.incrementAndGet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void decrementReference() {
            if (this.referenceCount.decrementAndGet() == 0) {
                Object object = LOCK;
                synchronized (object) {
                    if (this.referenceCount.get() == 0) {
                        this.close();
                        instance = null;
                        LOGGER.info("Global async HTTP client has been shut down");
                    }
                }
            }
        }

        @Override
        public void close() {
            LOGGER.info("Closing global async HTTP client");
            this.connectionEvictor.shutdown();
            this.client.close(CloseMode.GRACEFUL);
            this.connectionManager.close();
        }
    }
}

