/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.dbclient.impl.sqlexec;

import com.databricks.internal.google.common.annotations.VisibleForTesting;
import com.databricks.internal.sdk.WorkspaceClient;
import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.core.DatabricksConfig;
import com.databricks.internal.sdk.core.DatabricksError;
import com.databricks.internal.sdk.core.http.Request;
import com.databricks.internal.sdk.service.sql.ExecuteStatementRequestOnWaitTimeout;
import com.databricks.internal.sdk.service.sql.Format;
import com.databricks.internal.sdk.service.sql.GetStatementRequest;
import com.databricks.internal.sdk.service.sql.GetStatementResultChunkNRequest;
import com.databricks.internal.sdk.service.sql.ServiceError;
import com.databricks.internal.sdk.service.sql.StatementExecutionService;
import com.databricks.internal.sdk.service.sql.StatementParameterListItem;
import com.databricks.internal.sdk.service.sql.StatementState;
import com.databricks.jdbc.api.impl.DatabricksResultSet;
import com.databricks.jdbc.api.impl.ImmutableSessionInfo;
import com.databricks.jdbc.api.impl.ImmutableSqlParameter;
import com.databricks.jdbc.api.internal.IDatabricksConnectionContext;
import com.databricks.jdbc.api.internal.IDatabricksSession;
import com.databricks.jdbc.api.internal.IDatabricksStatementInternal;
import com.databricks.jdbc.common.CompressionCodec;
import com.databricks.jdbc.common.DatabricksClientConfiguratorManager;
import com.databricks.jdbc.common.DatabricksJdbcConstants;
import com.databricks.jdbc.common.IDatabricksComputeResource;
import com.databricks.jdbc.common.StatementType;
import com.databricks.jdbc.common.Warehouse;
import com.databricks.jdbc.common.util.DatabricksThreadContextHolder;
import com.databricks.jdbc.common.util.DatabricksTypeUtil;
import com.databricks.jdbc.dbclient.IDatabricksClient;
import com.databricks.jdbc.dbclient.impl.common.ClientConfigurator;
import com.databricks.jdbc.dbclient.impl.common.StatementId;
import com.databricks.jdbc.dbclient.impl.common.TimeoutHandler;
import com.databricks.jdbc.dbclient.impl.common.TracingUtil;
import com.databricks.jdbc.exception.DatabricksHttpException;
import com.databricks.jdbc.exception.DatabricksParsingException;
import com.databricks.jdbc.exception.DatabricksSQLException;
import com.databricks.jdbc.exception.DatabricksTemporaryRedirectException;
import com.databricks.jdbc.exception.DatabricksTimeoutException;
import com.databricks.jdbc.exception.DatabricksValidationException;
import com.databricks.jdbc.log.JdbcLogger;
import com.databricks.jdbc.log.JdbcLoggerFactory;
import com.databricks.jdbc.model.client.sqlexec.CancelStatementRequest;
import com.databricks.jdbc.model.client.sqlexec.CloseStatementRequest;
import com.databricks.jdbc.model.client.sqlexec.CreateSessionRequest;
import com.databricks.jdbc.model.client.sqlexec.CreateSessionResponse;
import com.databricks.jdbc.model.client.sqlexec.DeleteSessionRequest;
import com.databricks.jdbc.model.client.sqlexec.ExecuteStatementRequest;
import com.databricks.jdbc.model.client.sqlexec.ExecuteStatementResponse;
import com.databricks.jdbc.model.client.sqlexec.GetStatementResponse;
import com.databricks.jdbc.model.client.sqlexec.PositionalStatementParameterListItem;
import com.databricks.jdbc.model.client.thrift.generated.TFetchResultsResp;
import com.databricks.jdbc.model.core.Disposition;
import com.databricks.jdbc.model.core.ExternalLink;
import com.databricks.jdbc.model.core.ResultData;
import com.databricks.jdbc.model.telemetry.enums.DatabricksDriverErrorCode;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.SQLException;
import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.net.ssl.SSLHandshakeException;

public class DatabricksSdkClient
implements IDatabricksClient {
    private static final JdbcLogger LOGGER = JdbcLoggerFactory.getLogger(DatabricksSdkClient.class);
    private static final String SYNC_TIMEOUT_VALUE = "10s";
    private static final String ASYNC_TIMEOUT_VALUE = "0s";
    private final IDatabricksConnectionContext connectionContext;
    private final ClientConfigurator clientConfigurator;
    private volatile WorkspaceClient workspaceClient;
    private volatile ApiClient apiClient;

    public DatabricksSdkClient(IDatabricksConnectionContext connectionContext) throws DatabricksParsingException, DatabricksHttpException {
        this.connectionContext = connectionContext;
        this.clientConfigurator = DatabricksClientConfiguratorManager.getInstance().getConfigurator(connectionContext);
        this.workspaceClient = this.clientConfigurator.getWorkspaceClient();
        this.apiClient = this.workspaceClient.apiClient();
    }

    @VisibleForTesting
    public DatabricksSdkClient(IDatabricksConnectionContext connectionContext, StatementExecutionService statementExecutionService, ApiClient apiClient) throws DatabricksParsingException, DatabricksHttpException {
        this.connectionContext = connectionContext;
        this.clientConfigurator = DatabricksClientConfiguratorManager.getInstance().getConfigurator(connectionContext);
        this.workspaceClient = new WorkspaceClient(true, apiClient).withStatementExecutionImpl(statementExecutionService);
        this.apiClient = apiClient;
    }

    @Override
    public IDatabricksConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    @Override
    public ImmutableSessionInfo createSession(IDatabricksComputeResource warehouse, String catalog, String schema, Map<String, String> sessionConf) throws DatabricksSQLException {
        LOGGER.debug("public Session createSession(String warehouseId = {}, String catalog = {}, String schema = {}, Map<String, String> sessionConf = {})", ((Warehouse)warehouse).getWarehouseId(), catalog, schema, sessionConf);
        CreateSessionRequest request = new CreateSessionRequest().setWarehouseId(((Warehouse)warehouse).getWarehouseId());
        if (catalog != null) {
            request.setCatalog(catalog);
        }
        if (schema != null) {
            request.setSchema(schema);
        }
        if (sessionConf != null && !sessionConf.isEmpty()) {
            request.setSessionConfigs(sessionConf);
        }
        CreateSessionResponse createSessionResponse = null;
        try {
            Request req = new Request("POST", "/api/2.0/sql/sessions/", this.apiClient.serialize(request));
            req.withHeaders(this.getHeaders("createSession"));
            createSessionResponse = this.apiClient.execute(req, CreateSessionResponse.class);
        }
        catch (DatabricksError e) {
            if (e.getStatusCode() == 307) {
                throw new DatabricksTemporaryRedirectException(DatabricksDriverErrorCode.TEMPORARY_REDIRECT_EXCEPTION);
            }
            String errorReason = this.buildErrorMessage(e);
            throw new DatabricksSQLException(errorReason, (Throwable)e, DatabricksDriverErrorCode.CONNECTION_ERROR);
        }
        catch (IOException e) {
            String errorMessage = "Error while processing the request via the sdk client";
            LOGGER.error(errorMessage, e);
            throw new DatabricksSQLException(errorMessage, (Throwable)e, DatabricksDriverErrorCode.SDK_CLIENT_ERROR);
        }
        DatabricksThreadContextHolder.setSessionId(createSessionResponse.getSessionId());
        return ImmutableSessionInfo.builder().computeResource(warehouse).sessionId(createSessionResponse.getSessionId()).build();
    }

    @Override
    public void deleteSession(ImmutableSessionInfo sessionInfo) throws DatabricksSQLException {
        LOGGER.debug("public void deleteSession(String sessionId = {})", sessionInfo.sessionId());
        DatabricksThreadContextHolder.setSessionId(sessionInfo.sessionId());
        DeleteSessionRequest request = new DeleteSessionRequest().setSessionId(sessionInfo.sessionId()).setWarehouseId(((Warehouse)sessionInfo.computeResource()).getWarehouseId());
        String path = String.format("/api/2.0/sql/sessions/%s", request.getSessionId());
        try {
            Request req = new Request("DELETE", path);
            req.withHeaders(this.getHeaders("deleteSession"));
            ApiClient.setQuery(req, request);
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            String errorMessage = "Error while performing the deleting session operation";
            LOGGER.error(errorMessage, e);
            throw new DatabricksSQLException(errorMessage, (Throwable)e, DatabricksDriverErrorCode.SDK_CLIENT_ERROR);
        }
    }

    @Override
    public DatabricksResultSet executeStatement(String sql, IDatabricksComputeResource computeResource, Map<Integer, ImmutableSqlParameter> parameters, StatementType statementType, IDatabricksSession session, IDatabricksStatementInternal parentStatement) throws SQLException {
        ExecuteStatementResponse response;
        LOGGER.debug("public DatabricksResultSet executeStatement(String sql = {}, compute resource = {}, Map<Integer, ImmutableSqlParameter> parameters = {}, StatementType statementType = {}, IDatabricksSession session = {}, parentStatement = {})", new Object[]{sql, computeResource.toString(), parameters, statementType, session, parentStatement});
        DatabricksThreadContextHolder.setSessionId(session.getSessionId());
        long pollCount = 0L;
        long executionStartTime = Instant.now().toEpochMilli();
        DatabricksThreadContextHolder.setStatementType(statementType);
        ExecuteStatementRequest request = this.getRequest(statementType, sql, ((Warehouse)computeResource).getWarehouseId(), session, parameters, parentStatement, false);
        try {
            Request req = new Request("POST", "/api/2.0/sql/statements/", this.apiClient.serialize(request));
            req.withHeaders(this.getHeaders("executeStatement"));
            response = this.apiClient.execute(req, ExecuteStatementResponse.class);
        }
        catch (IOException e) {
            String errorMessage = "Error while processing the execute statement request";
            LOGGER.error(errorMessage, e);
            throw new DatabricksSQLException(errorMessage, (Throwable)e, DatabricksDriverErrorCode.SDK_CLIENT_ERROR);
        }
        String statementId = response.getStatementId();
        if (statementId == null) {
            LOGGER.error("Empty Statement ID for sql {}, statementType {}, compute {}", new Object[]{sql, statementType, computeResource});
            this.handleFailedExecution(response, "", sql);
        }
        LOGGER.debug("Executing sql = {}, statementType = {}, compute = {}, StatementID = {}", new Object[]{sql, statementType, computeResource, statementId});
        StatementId typedStatementId = new StatementId(statementId);
        DatabricksThreadContextHolder.setStatementId(typedStatementId);
        if (parentStatement != null) {
            parentStatement.setStatementId(typedStatementId);
        }
        int timeoutInSeconds = parentStatement != null ? parentStatement.getStatement().getQueryTimeout() : 0;
        TimeoutHandler timeoutHandler = TimeoutHandler.forStatement(timeoutInSeconds, typedStatementId, this);
        StatementState responseState = response.getStatus().getState();
        while (responseState == StatementState.PENDING || responseState == StatementState.RUNNING) {
            timeoutHandler.checkTimeout();
            if (pollCount > 0L) {
                try {
                    Thread.sleep(this.connectionContext.getAsyncExecPollInterval());
                }
                catch (InterruptedException e) {
                    String timeoutErrorMessage = String.format("Thread interrupted due to statement timeout. StatementID %s", statementId);
                    LOGGER.error(timeoutErrorMessage);
                    throw new DatabricksTimeoutException(timeoutErrorMessage);
                }
            }
            String getStatusPath = String.format("/api/2.0/sql/statements/%s", statementId);
            try {
                Request req = new Request("GET", getStatusPath, this.apiClient.serialize(request));
                req.withHeaders(this.getHeaders("getStatement"));
                response = this.wrapGetStatementResponse(this.apiClient.execute(req, GetStatementResponse.class));
            }
            catch (IOException e) {
                String errorMessage = "Error while processing the get statement response";
                LOGGER.error(errorMessage, e);
                throw new DatabricksSQLException(errorMessage, (Throwable)e, DatabricksDriverErrorCode.SDK_CLIENT_ERROR);
            }
            responseState = response.getStatus().getState();
            LOGGER.debug("Executed sql {} with status {} with retry count {}", new Object[]{sql, responseState, pollCount});
            ++pollCount;
        }
        long executionEndTime = Instant.now().toEpochMilli();
        LOGGER.debug("Executed sql {} with status {}, total time taken {} and pollCount {}", new Object[]{sql, responseState, executionEndTime - executionStartTime, pollCount});
        if (responseState != StatementState.SUCCEEDED) {
            this.handleFailedExecution(response, statementId, sql);
        }
        return new DatabricksResultSet(response.getStatus(), typedStatementId, response.getResult(), response.getManifest(), statementType, session, parentStatement);
    }

    @Override
    public DatabricksResultSet executeStatementAsync(String sql, IDatabricksComputeResource computeResource, Map<Integer, ImmutableSqlParameter> parameters, IDatabricksSession session, IDatabricksStatementInternal parentStatement) throws SQLException {
        ExecuteStatementResponse response;
        LOGGER.debug("public DatabricksResultSet executeStatementAsync(String sql = {}, compute resource = {}, Map<Integer, ImmutableSqlParameter> parameters, IDatabricksSession session = {}, IDatabricksStatementInternal parentStatement = {})", sql, computeResource.toString(), session, parentStatement);
        DatabricksThreadContextHolder.setSessionId(session.getSessionId());
        ExecuteStatementRequest request = this.getRequest(StatementType.SQL, sql, ((Warehouse)computeResource).getWarehouseId(), session, parameters, parentStatement, true);
        try {
            Request req = new Request("POST", "/api/2.0/sql/statements/", this.apiClient.serialize(request));
            req.withHeaders(this.getHeaders("executeStatement"));
            response = this.apiClient.execute(req, ExecuteStatementResponse.class);
        }
        catch (IOException e) {
            String errorMessage = "Error while processing the execute statement async request";
            LOGGER.error(errorMessage, e);
            throw new DatabricksSQLException(errorMessage, (Throwable)e, DatabricksDriverErrorCode.SDK_CLIENT_ERROR);
        }
        String statementId = response.getStatementId();
        if (statementId == null) {
            LOGGER.error("Empty Statement ID for sql {}, compute {}", sql, computeResource.toString());
            this.handleFailedExecution(response, "", sql);
        }
        StatementId typedStatementId = new StatementId(statementId);
        DatabricksThreadContextHolder.setStatementId(typedStatementId);
        if (parentStatement != null) {
            parentStatement.setStatementId(typedStatementId);
        }
        LOGGER.debug("Executed sql [{}] with status [{}]", new Object[]{sql, response.getStatus().getState()});
        return new DatabricksResultSet(response.getStatus(), typedStatementId, response.getResult(), response.getManifest(), StatementType.SQL, session, parentStatement);
    }

    @Override
    public DatabricksResultSet getStatementResult(StatementId typedStatementId, IDatabricksSession session, IDatabricksStatementInternal parentStatement) throws DatabricksSQLException {
        GetStatementResponse response;
        DatabricksThreadContextHolder.setStatementId(typedStatementId);
        DatabricksThreadContextHolder.setSessionId(session.getSessionId());
        String statementId = typedStatementId.toSQLExecStatementId();
        GetStatementRequest request = new GetStatementRequest().setStatementId(statementId);
        String getStatusPath = String.format("/api/2.0/sql/statements/%s", statementId);
        try {
            Request req = new Request("GET", getStatusPath, this.apiClient.serialize(request));
            req.withHeaders(this.getHeaders("getStatement"));
            response = this.apiClient.execute(req, GetStatementResponse.class);
        }
        catch (IOException e) {
            String errorMessage = "Error while processing the get statement result request";
            LOGGER.error(errorMessage, e);
            throw new DatabricksSQLException(errorMessage, (Throwable)e, DatabricksDriverErrorCode.SDK_CLIENT_ERROR);
        }
        return new DatabricksResultSet(response.getStatus(), typedStatementId, response.getResult(), response.getManifest(), StatementType.SQL, session, parentStatement);
    }

    @Override
    public void closeStatement(StatementId typedStatementId) throws DatabricksSQLException {
        String statementId = typedStatementId.toSQLExecStatementId();
        DatabricksThreadContextHolder.setStatementId(typedStatementId);
        LOGGER.debug(String.format("public void closeStatement(String statementId = {})", statementId));
        CloseStatementRequest request = new CloseStatementRequest().setStatementId(statementId);
        String path = String.format("/api/2.0/sql/statements/%s", request.getStatementId());
        try {
            Request req = new Request("DELETE", path, this.apiClient.serialize(request));
            req.withHeaders(this.getHeaders("closeStatement"));
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            String errorMessage = "Error while processing the close statement request";
            LOGGER.error(errorMessage, e);
            throw new DatabricksSQLException(errorMessage, (Throwable)e, DatabricksDriverErrorCode.SDK_CLIENT_ERROR);
        }
    }

    @Override
    public void cancelStatement(StatementId typedStatementId) throws DatabricksSQLException {
        String statementId = typedStatementId.toSQLExecStatementId();
        DatabricksThreadContextHolder.setStatementId(typedStatementId);
        LOGGER.debug("public void cancelStatement(String statementId = {})", statementId);
        CancelStatementRequest request = new CancelStatementRequest().setStatementId(statementId);
        String path = String.format("/api/2.0/sql/statements/%s/cancel", request.getStatementId());
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            req.withHeaders(this.getHeaders("cancelStatement"));
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            String errorMessage = "Error while processing the cancel statement request";
            LOGGER.error(errorMessage, e);
            throw new DatabricksSQLException(errorMessage, (Throwable)e, DatabricksDriverErrorCode.SDK_CLIENT_ERROR);
        }
    }

    @Override
    public Collection<ExternalLink> getResultChunks(StatementId typedStatementId, long chunkIndex) throws DatabricksSQLException {
        DatabricksThreadContextHolder.setStatementId(typedStatementId);
        String statementId = typedStatementId.toSQLExecStatementId();
        LOGGER.debug("public Optional<ExternalLink> getResultChunk(String statementId = {}, long chunkIndex = {})", statementId, chunkIndex);
        GetStatementResultChunkNRequest request = new GetStatementResultChunkNRequest().setStatementId(statementId).setChunkIndex(chunkIndex);
        String path = String.format("/api/2.0/sql/statements/%s/result/chunks/%s", statementId, chunkIndex);
        try {
            Request req = new Request("GET", path, this.apiClient.serialize(request));
            req.withHeaders(this.getHeaders("getStatementResultN"));
            ResultData resultData = this.apiClient.execute(req, ResultData.class);
            return resultData.getExternalLinks();
        }
        catch (IOException e) {
            String errorMessage = "Error while processing the get result chunk request";
            LOGGER.error(errorMessage, e);
            throw new DatabricksSQLException(errorMessage, (Throwable)e, DatabricksDriverErrorCode.SDK_CLIENT_ERROR);
        }
    }

    @Override
    public synchronized void resetAccessToken(String newAccessToken) {
        this.clientConfigurator.resetAccessTokenInConfig(newAccessToken);
        this.workspaceClient = this.clientConfigurator.getWorkspaceClient();
        this.apiClient = this.workspaceClient.apiClient();
    }

    @Override
    public TFetchResultsResp getMoreResults(IDatabricksStatementInternal parentStatement) throws DatabricksSQLException {
        throw new DatabricksValidationException("Get more results cannot be called for SEA flow");
    }

    @Override
    public DatabricksConfig getDatabricksConfig() {
        return this.clientConfigurator.getDatabricksConfig();
    }

    private boolean useCloudFetchForResult(StatementType statementType) {
        return this.connectionContext.shouldEnableArrow() != false && (statementType == StatementType.QUERY || statementType == StatementType.SQL || statementType == StatementType.METADATA);
    }

    private Map<String, String> getHeaders(String method) {
        HashMap<String, String> headers = new HashMap<String, String>(DatabricksJdbcConstants.JSON_HTTP_HEADERS);
        if (this.connectionContext.isRequestTracingEnabled()) {
            String traceHeader = TracingUtil.getTraceHeader();
            LOGGER.debug("Tracing header for method {}: [{}]", method, traceHeader);
            headers.put("traceparent", traceHeader);
        }
        headers.putAll(this.connectionContext.getCustomHeaders());
        return headers;
    }

    private ExecuteStatementRequest getRequest(StatementType statementType, String sql, String warehouseId, IDatabricksSession session, Map<Integer, ImmutableSqlParameter> parameters, IDatabricksStatementInternal parentStatement, boolean executeAsync) throws SQLException {
        Format format = this.useCloudFetchForResult(statementType) ? Format.ARROW_STREAM : Format.JSON_ARRAY;
        Disposition defaultDisposition = this.connectionContext.isSqlExecHybridResultsEnabled() ? Disposition.INLINE_OR_EXTERNAL_LINKS : Disposition.EXTERNAL_LINKS;
        Disposition disposition = this.useCloudFetchForResult(statementType) ? defaultDisposition : Disposition.INLINE;
        long maxRows = parentStatement == null ? 2000000L : (long)parentStatement.getMaxRows();
        CompressionCodec compressionCodec = session.getCompressionCodec();
        if (disposition.equals((Object)Disposition.INLINE)) {
            LOGGER.debug("Results are inline, skipping compression.");
            compressionCodec = CompressionCodec.NONE;
        }
        List<StatementParameterListItem> parameterListItems = parameters.values().stream().map(this::mapToParameterListItem).collect(Collectors.toList());
        ExecuteStatementRequest request = new ExecuteStatementRequest().setSessionId(session.getSessionId()).setStatement(sql).setWarehouseId(warehouseId).setDisposition(disposition).setFormat(format).setResultCompression(compressionCodec).setParameters(parameterListItems);
        if (executeAsync) {
            request.setWaitTimeout(ASYNC_TIMEOUT_VALUE);
        } else {
            request.setWaitTimeout(SYNC_TIMEOUT_VALUE).setOnWaitTimeout(ExecuteStatementRequestOnWaitTimeout.CONTINUE);
        }
        if (maxRows != 2000000L) {
            request.setRowLimit(maxRows);
        }
        return request;
    }

    @VisibleForTesting
    StatementParameterListItem mapToParameterListItem(ImmutableSqlParameter parameter) {
        Object value = parameter.value();
        String typeString = parameter.type().name();
        if (typeString.equals("DECIMAL") && value instanceof BigDecimal) {
            typeString = DatabricksTypeUtil.getDecimalTypeString((BigDecimal)value);
        }
        return new PositionalStatementParameterListItem().setOrdinal(parameter.cardinal()).setType(typeString).setValue(value != null ? value.toString() : null);
    }

    void handleFailedExecution(ExecuteStatementResponse response, String statementId, String statement) throws SQLException {
        StatementState statementState = response.getStatus().getState();
        ServiceError error = response.getStatus().getError();
        Object errorMessage = String.format("Statement execution failed %s -> %s\n%s.", new Object[]{statementId, statement, statementState});
        if (error != null) {
            errorMessage = (String)errorMessage + String.format(" Error Message: %s, Error code: %s", new Object[]{error.getMessage(), error.getErrorCode()});
        }
        LOGGER.debug((String)errorMessage);
        throw new DatabricksSQLException((String)errorMessage, response.getStatus().getSqlState(), DatabricksDriverErrorCode.EXECUTE_STATEMENT_FAILED);
    }

    private ExecuteStatementResponse wrapGetStatementResponse(GetStatementResponse getStatementResponse) {
        return new ExecuteStatementResponse().setStatementId(getStatementResponse.getStatementId()).setStatus(getStatementResponse.getStatus()).setManifest(getStatementResponse.getManifest()).setResult(getStatementResponse.getResult());
    }

    private String buildErrorMessage(DatabricksError e) {
        boolean isCertificatePathError;
        boolean isSSLException = Stream.iterate(e.getCause(), Objects::nonNull, Throwable::getCause).anyMatch(cause -> cause instanceof SSLHandshakeException);
        boolean bl = isCertificatePathError = e.getMessage().contains("PKIX path building failed") || e.getMessage().contains("unable to find valid certification path");
        if (isSSLException && isCertificatePathError) {
            return this.buildSSLCertificatePathErrorMessage(e);
        }
        return "Error while establishing a connection in databricks";
    }

    private String buildSSLCertificatePathErrorMessage(DatabricksError e) {
        Object customTruststorePathMessage = "";
        if (this.connectionContext != null && this.connectionContext.getSSLTrustStore() != null) {
            customTruststorePathMessage = " in truststore: " + this.connectionContext.getSSLTrustStore();
        }
        String workspaceHostname = "<workspace>";
        try {
            if (this.connectionContext != null && this.connectionContext.getHostUrl() != null) {
                workspaceHostname = new URL(this.connectionContext.getHostUrl()).getHost();
            }
        }
        catch (Exception ex) {
            LOGGER.debug("Could not retrieve workspace hostname for error message", ex);
        }
        return String.format("Unable to find certification path to requested target%s\n\nSSL Error: %s\n\nDetails: TLS handshake failure due to TLS Certificate of server being connected is not in the configured truststore.\n\nNext steps:\n- Make sure that the connection string has the appropriate Databricks workspace FQDN.\n\n- Verify the configured truststore path and make sure the required certificates are imported.\n  .   PEM certificate chain of the warehouse endpoint can be fetched using \"openssl s_client -connect %s:443 -showcerts\"\n  .   Reference KB article with troubleshooting steps.\n", customTruststorePathMessage, e.getMessage(), workspaceHostname);
    }
}

