/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.telemetry;

import com.databricks.internal.sdk.core.DatabricksConfig;
import com.databricks.jdbc.api.internal.IDatabricksConnectionContext;
import com.databricks.jdbc.model.telemetry.TelemetryFrontendLog;
import com.databricks.jdbc.telemetry.ITelemetryClient;
import com.databricks.jdbc.telemetry.TelemetryPushTask;
import com.databricks.jdbc.telemetry.latency.TelemetryCollector;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class TelemetryClient
implements ITelemetryClient {
    private final IDatabricksConnectionContext context;
    private final DatabricksConfig databricksConfig;
    private final int eventsBatchSize;
    private final boolean isAuthEnabled;
    private final ExecutorService executorService;
    private final ScheduledExecutorService scheduledExecutorService;
    private List<TelemetryFrontendLog> eventsBatch = new LinkedList<TelemetryFrontendLog>();
    private volatile long lastFlushedTime;
    private ScheduledFuture<?> flushTask;
    private final int flushIntervalMillis;

    public TelemetryClient(IDatabricksConnectionContext connectionContext, ExecutorService executorService, DatabricksConfig config) {
        this.eventsBatchSize = connectionContext.getTelemetryBatchSize();
        this.isAuthEnabled = true;
        this.context = connectionContext;
        this.databricksConfig = config;
        this.executorService = executorService;
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
        this.flushIntervalMillis = this.context.getTelemetryFlushIntervalInMilliseconds();
        this.lastFlushedTime = System.currentTimeMillis();
        this.schedulePeriodicFlush();
    }

    public TelemetryClient(IDatabricksConnectionContext connectionContext, ExecutorService executorService) {
        this.eventsBatchSize = connectionContext.getTelemetryBatchSize();
        this.isAuthEnabled = false;
        this.context = connectionContext;
        this.databricksConfig = null;
        this.executorService = executorService;
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
        this.flushIntervalMillis = this.context.getTelemetryFlushIntervalInMilliseconds();
        this.lastFlushedTime = System.currentTimeMillis();
        this.schedulePeriodicFlush();
    }

    private void schedulePeriodicFlush() {
        if (this.flushTask != null) {
            this.flushTask.cancel(false);
        }
        this.flushTask = this.scheduledExecutorService.scheduleAtFixedRate(this::periodicFlush, this.flushIntervalMillis, this.flushIntervalMillis, TimeUnit.MILLISECONDS);
    }

    private void periodicFlush() {
        long now = System.currentTimeMillis();
        if (now - this.lastFlushedTime >= (long)this.flushIntervalMillis) {
            this.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportEvent(TelemetryFrontendLog event) {
        TelemetryClient telemetryClient = this;
        synchronized (telemetryClient) {
            this.eventsBatch.add(event);
        }
        if (this.eventsBatch.size() == this.eventsBatchSize) {
            this.flush();
        }
    }

    @Override
    public void close() {
        TelemetryCollector.getInstance().exportAllPendingTelemetryDetails();
        this.flush();
        if (this.flushTask != null) {
            this.flushTask.cancel(false);
        }
        this.scheduledExecutorService.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush() {
        TelemetryClient telemetryClient = this;
        synchronized (telemetryClient) {
            if (!this.eventsBatch.isEmpty()) {
                List<TelemetryFrontendLog> logsToBeFlushed = this.eventsBatch;
                this.executorService.submit(new TelemetryPushTask(logsToBeFlushed, this.isAuthEnabled, this.context, this.databricksConfig));
                this.eventsBatch = new LinkedList<TelemetryFrontendLog>();
            }
            this.lastFlushedTime = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getCurrentSize() {
        TelemetryClient telemetryClient = this;
        synchronized (telemetryClient) {
            return this.eventsBatch.size();
        }
    }
}

