/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.telemetry;

import com.databricks.internal.google.common.annotations.VisibleForTesting;
import com.databricks.internal.sdk.core.DatabricksConfig;
import com.databricks.jdbc.api.internal.IDatabricksConnectionContext;
import com.databricks.jdbc.log.JdbcLogger;
import com.databricks.jdbc.log.JdbcLoggerFactory;
import com.databricks.jdbc.telemetry.ITelemetryClient;
import com.databricks.jdbc.telemetry.NoopTelemetryClient;
import com.databricks.jdbc.telemetry.TelemetryClient;
import com.databricks.jdbc.telemetry.TelemetryHelper;
import java.util.LinkedHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class TelemetryClientFactory {
    private static final JdbcLogger LOGGER = JdbcLoggerFactory.getLogger(TelemetryClientFactory.class);
    private static final TelemetryClientFactory INSTANCE = new TelemetryClientFactory();
    @VisibleForTesting
    final LinkedHashMap<String, TelemetryClient> telemetryClients = new LinkedHashMap();
    @VisibleForTesting
    final LinkedHashMap<String, TelemetryClient> noauthTelemetryClients = new LinkedHashMap();
    private final ExecutorService telemetryExecutorService = Executors.newFixedThreadPool(10);

    private TelemetryClientFactory() {
    }

    public static TelemetryClientFactory getInstance() {
        return INSTANCE;
    }

    public ITelemetryClient getTelemetryClient(IDatabricksConnectionContext connectionContext) {
        if (!TelemetryHelper.isTelemetryAllowedForConnection(connectionContext)) {
            return NoopTelemetryClient.getInstance();
        }
        DatabricksConfig databricksConfig = TelemetryHelper.getDatabricksConfigSafely(connectionContext);
        if (databricksConfig != null) {
            return this.telemetryClients.computeIfAbsent(connectionContext.getConnectionUuid(), k -> new TelemetryClient(connectionContext, this.getTelemetryExecutorService(), databricksConfig));
        }
        return this.noauthTelemetryClients.computeIfAbsent(connectionContext.getConnectionUuid(), k -> new TelemetryClient(connectionContext, this.getTelemetryExecutorService()));
    }

    public void closeTelemetryClient(IDatabricksConnectionContext connectionContext) {
        this.closeTelemetryClient((ITelemetryClient)this.telemetryClients.remove(connectionContext.getConnectionUuid()), "telemetry client");
        this.closeTelemetryClient((ITelemetryClient)this.noauthTelemetryClients.remove(connectionContext.getConnectionUuid()), "unauthenticated telemetry client");
    }

    public ExecutorService getTelemetryExecutorService() {
        return this.telemetryExecutorService;
    }

    @VisibleForTesting
    public void reset() {
        this.telemetryClients.values().forEach(TelemetryClient::close);
        this.noauthTelemetryClients.values().forEach(TelemetryClient::close);
        this.telemetryClients.clear();
        this.noauthTelemetryClients.clear();
    }

    private void closeTelemetryClient(ITelemetryClient client, String clientType) {
        if (client != null) {
            try {
                client.close();
            }
            catch (Exception e) {
                LOGGER.debug("Caught error while closing {}. Error: {}", clientType, e);
            }
        }
    }
}

