/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.bouncycastle.crypto.agreement;

import com.databricks.internal.bouncycastle.crypto.BasicAgreement;
import com.databricks.internal.bouncycastle.crypto.CipherParameters;
import com.databricks.internal.bouncycastle.crypto.CryptoServicesRegistrar;
import com.databricks.internal.bouncycastle.crypto.agreement.Utils;
import com.databricks.internal.bouncycastle.crypto.params.ECDomainParameters;
import com.databricks.internal.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.databricks.internal.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.databricks.internal.bouncycastle.crypto.params.MQVPrivateParameters;
import com.databricks.internal.bouncycastle.crypto.params.MQVPublicParameters;
import com.databricks.internal.bouncycastle.math.ec.ECAlgorithms;
import com.databricks.internal.bouncycastle.math.ec.ECConstants;
import com.databricks.internal.bouncycastle.math.ec.ECCurve;
import com.databricks.internal.bouncycastle.math.ec.ECPoint;
import com.databricks.internal.bouncycastle.util.Properties;
import java.math.BigInteger;

public class ECMQVBasicAgreement
implements BasicAgreement {
    MQVPrivateParameters privParams;

    @Override
    public void init(CipherParameters cipherParameters) {
        this.privParams = (MQVPrivateParameters)cipherParameters;
        CryptoServicesRegistrar.checkConstraints(Utils.getDefaultProperties("ECMQV", this.privParams.getStaticPrivateKey()));
    }

    @Override
    public int getFieldSize() {
        return (this.privParams.getStaticPrivateKey().getParameters().getCurve().getFieldSize() + 7) / 8;
    }

    @Override
    public BigInteger calculateAgreement(CipherParameters cipherParameters) {
        if (Properties.isOverrideSet("com.databricks.internal.bouncycastle.ec.disable_mqv")) {
            throw new IllegalStateException("ECMQV explicitly disabled");
        }
        MQVPublicParameters mQVPublicParameters = (MQVPublicParameters)cipherParameters;
        ECPrivateKeyParameters eCPrivateKeyParameters = this.privParams.getStaticPrivateKey();
        ECDomainParameters eCDomainParameters = eCPrivateKeyParameters.getParameters();
        if (!eCDomainParameters.equals(mQVPublicParameters.getStaticPublicKey().getParameters())) {
            throw new IllegalStateException("ECMQV public key components have wrong domain parameters");
        }
        ECPoint eCPoint = this.calculateMqvAgreement(eCDomainParameters, eCPrivateKeyParameters, this.privParams.getEphemeralPrivateKey(), this.privParams.getEphemeralPublicKey(), mQVPublicParameters.getStaticPublicKey(), mQVPublicParameters.getEphemeralPublicKey()).normalize();
        if (eCPoint.isInfinity()) {
            throw new IllegalStateException("Infinity is not a valid agreement value for MQV");
        }
        return eCPoint.getAffineXCoord().toBigInteger();
    }

    private ECPoint calculateMqvAgreement(ECDomainParameters eCDomainParameters, ECPrivateKeyParameters eCPrivateKeyParameters, ECPrivateKeyParameters eCPrivateKeyParameters2, ECPublicKeyParameters eCPublicKeyParameters, ECPublicKeyParameters eCPublicKeyParameters2, ECPublicKeyParameters eCPublicKeyParameters3) {
        BigInteger bigInteger = eCDomainParameters.getN();
        int n = (bigInteger.bitLength() + 1) / 2;
        BigInteger bigInteger2 = ECConstants.ONE.shiftLeft(n);
        ECCurve eCCurve = eCDomainParameters.getCurve();
        ECPoint eCPoint = ECAlgorithms.cleanPoint(eCCurve, eCPublicKeyParameters.getQ());
        ECPoint eCPoint2 = ECAlgorithms.cleanPoint(eCCurve, eCPublicKeyParameters2.getQ());
        ECPoint eCPoint3 = ECAlgorithms.cleanPoint(eCCurve, eCPublicKeyParameters3.getQ());
        BigInteger bigInteger3 = eCPoint.getAffineXCoord().toBigInteger();
        BigInteger bigInteger4 = bigInteger3.mod(bigInteger2);
        BigInteger bigInteger5 = bigInteger4.setBit(n);
        BigInteger bigInteger6 = eCPrivateKeyParameters.getD().multiply(bigInteger5).add(eCPrivateKeyParameters2.getD()).mod(bigInteger);
        BigInteger bigInteger7 = eCPoint3.getAffineXCoord().toBigInteger();
        BigInteger bigInteger8 = bigInteger7.mod(bigInteger2);
        BigInteger bigInteger9 = bigInteger8.setBit(n);
        BigInteger bigInteger10 = eCDomainParameters.getH().multiply(bigInteger6).mod(bigInteger);
        return ECAlgorithms.sumOfTwoMultiplies(eCPoint2, bigInteger9.multiply(bigInteger10).mod(bigInteger), eCPoint3, bigInteger10);
    }
}

