/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.bouncycastle.jcajce.provider.digest;

import com.databricks.internal.bouncycastle.crypto.CipherKeyGenerator;
import com.databricks.internal.bouncycastle.crypto.digests.WhirlpoolDigest;
import com.databricks.internal.bouncycastle.crypto.macs.HMac;
import com.databricks.internal.bouncycastle.internal.asn1.iso.ISOIECObjectIdentifiers;
import com.databricks.internal.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import com.databricks.internal.bouncycastle.jcajce.provider.digest.BCMessageDigest;
import com.databricks.internal.bouncycastle.jcajce.provider.digest.DigestAlgorithmProvider;
import com.databricks.internal.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import com.databricks.internal.bouncycastle.jcajce.provider.symmetric.util.BaseMac;

public class Whirlpool {
    private Whirlpool() {
    }

    public static class Digest
    extends BCMessageDigest
    implements Cloneable {
        public Digest() {
            super(new WhirlpoolDigest());
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            Digest digest = (Digest)super.clone();
            digest.digest = new WhirlpoolDigest((WhirlpoolDigest)this.digest);
            return digest;
        }
    }

    public static class HashMac
    extends BaseMac {
        public HashMac() {
            super(new HMac(new WhirlpoolDigest()));
        }
    }

    public static class KeyGenerator
    extends BaseKeyGenerator {
        public KeyGenerator() {
            super("HMACWHIRLPOOL", 512, new CipherKeyGenerator());
        }
    }

    public static class Mappings
    extends DigestAlgorithmProvider {
        private static final String PREFIX = Whirlpool.class.getName();

        @Override
        public void configure(ConfigurableProvider configurableProvider) {
            configurableProvider.addAlgorithm("MessageDigest.WHIRLPOOL", PREFIX + "$Digest");
            configurableProvider.addAlgorithm("MessageDigest", ISOIECObjectIdentifiers.whirlpool, PREFIX + "$Digest");
            this.addHMACAlgorithm(configurableProvider, "WHIRLPOOL", PREFIX + "$HashMac", PREFIX + "$KeyGenerator");
        }
    }
}

