/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.core;

import com.databricks.internal.sdk.core.DatabricksException;
import com.databricks.internal.sdk.core.error.ErrorDetail;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class DatabricksError
extends DatabricksException {
    private static final String ERROR_INFO_TYPE = "type.googleapis.com/google.rpc.ErrorInfo";
    private final String message;
    private final Throwable cause;
    private final String errorCode;
    private final int statusCode;
    private final List<ErrorDetail> details;

    public DatabricksError(int statusCode) {
        this("", "OK", statusCode, null, Collections.emptyList());
    }

    public DatabricksError(String errorCode, String message) {
        this(errorCode, message, 400, null, Collections.emptyList());
    }

    public DatabricksError(String errorCode, String message, int statusCode) {
        this(errorCode, message, statusCode, null, Collections.emptyList());
    }

    public DatabricksError(String errorCode, int statusCode, Throwable cause) {
        this(errorCode, cause.getMessage(), statusCode, cause, Collections.emptyList());
    }

    public DatabricksError(String errorCode, String message, int statusCode, List<ErrorDetail> details) {
        this(errorCode, message, statusCode, null, details);
    }

    private DatabricksError(String errorCode, String message, int statusCode, Throwable cause, List<ErrorDetail> details) {
        super(message, cause);
        this.errorCode = errorCode;
        this.message = message;
        this.cause = cause;
        this.statusCode = statusCode;
        this.details = details == null ? Collections.emptyList() : details;
    }

    public List<ErrorDetail> getErrorInfo() {
        return this.getDetailsByType(ERROR_INFO_TYPE);
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    @Override
    public Throwable getCause() {
        return this.cause;
    }

    List<ErrorDetail> getDetailsByType(String type) {
        return this.details.stream().filter(e -> e.getType().equals(type)).collect(Collectors.toList());
    }
}

