/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.core.oauth;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.core.DatabricksException;
import com.databricks.internal.sdk.core.http.FormRequest;
import com.databricks.internal.sdk.core.http.HttpClient;
import com.databricks.internal.sdk.core.http.Request;
import com.databricks.internal.sdk.core.oauth.AuthParameterPosition;
import com.databricks.internal.sdk.core.oauth.OAuthResponse;
import com.databricks.internal.sdk.core.oauth.Token;
import com.databricks.internal.sdk.core.oauth.TokenSource;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Base64;
import java.util.Map;

public abstract class RefreshableTokenSource
implements TokenSource {
    protected Token token;

    public RefreshableTokenSource() {
    }

    public RefreshableTokenSource(Token token) {
        this.token = token;
    }

    protected static Token retrieveToken(HttpClient hc, String clientId, String clientSecret, String tokenUrl, Map<String, String> params, Map<String, String> headers, AuthParameterPosition position) {
        switch (position) {
            case BODY: {
                if (clientId != null) {
                    params.put("client_id", clientId);
                }
                if (clientSecret == null) break;
                params.put("client_secret", clientSecret);
                break;
            }
            case HEADER: {
                String authHeaderValue = "Basic " + Base64.getEncoder().encodeToString((clientId + ":" + clientSecret).getBytes());
                headers.put("Authorization", authHeaderValue);
            }
        }
        headers.put("Content-Type", "application/x-www-form-urlencoded");
        Request req = new Request("POST", tokenUrl, FormRequest.wrapValuesInList(params));
        req.withHeaders(headers);
        try {
            ApiClient apiClient = new ApiClient.Builder().withHttpClient(hc).build();
            OAuthResponse resp = apiClient.execute(req, OAuthResponse.class);
            if (resp.getErrorCode() != null) {
                throw new IllegalArgumentException(resp.getErrorCode() + ": " + resp.getErrorSummary());
            }
            LocalDateTime expiry = LocalDateTime.now().plus(resp.getExpiresIn(), ChronoUnit.SECONDS);
            return new Token(resp.getAccessToken(), resp.getTokenType(), resp.getRefreshToken(), expiry);
        }
        catch (Exception e) {
            throw new DatabricksException("Failed to refresh credentials: " + e.getMessage(), e);
        }
    }

    protected abstract Token refresh();

    @Override
    public synchronized Token getToken() {
        if (this.token == null || !this.token.isValid()) {
            this.token = this.refresh();
        }
        return this.token;
    }
}

