/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.billing;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.service.billing.GetLogDeliveryRequest;
import com.databricks.internal.sdk.service.billing.ListLogDeliveryRequest;
import com.databricks.internal.sdk.service.billing.LogDeliveryConfigStatus;
import com.databricks.internal.sdk.service.billing.LogDeliveryConfiguration;
import com.databricks.internal.sdk.service.billing.LogDeliveryImpl;
import com.databricks.internal.sdk.service.billing.LogDeliveryService;
import com.databricks.internal.sdk.service.billing.UpdateLogDeliveryConfigurationStatusRequest;
import com.databricks.internal.sdk.service.billing.WrappedCreateLogDeliveryConfiguration;
import com.databricks.internal.sdk.service.billing.WrappedLogDeliveryConfiguration;
import com.databricks.internal.sdk.service.billing.WrappedLogDeliveryConfigurations;
import com.databricks.internal.sdk.support.Generated;
import com.databricks.internal.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class LogDeliveryAPI {
    private static final Logger LOG = LoggerFactory.getLogger(LogDeliveryAPI.class);
    private final LogDeliveryService impl;

    public LogDeliveryAPI(ApiClient apiClient) {
        this.impl = new LogDeliveryImpl(apiClient);
    }

    public LogDeliveryAPI(LogDeliveryService mock) {
        this.impl = mock;
    }

    public WrappedLogDeliveryConfiguration create(WrappedCreateLogDeliveryConfiguration request) {
        return this.impl.create(request);
    }

    public WrappedLogDeliveryConfiguration get(String logDeliveryConfigurationId) {
        return this.get(new GetLogDeliveryRequest().setLogDeliveryConfigurationId(logDeliveryConfigurationId));
    }

    public WrappedLogDeliveryConfiguration get(GetLogDeliveryRequest request) {
        return this.impl.get(request);
    }

    public Iterable<LogDeliveryConfiguration> list(ListLogDeliveryRequest request) {
        return new Paginator(request, this.impl::list, WrappedLogDeliveryConfigurations::getLogDeliveryConfigurations, response -> null);
    }

    public void patchStatus(String logDeliveryConfigurationId, LogDeliveryConfigStatus status) {
        this.patchStatus(new UpdateLogDeliveryConfigurationStatusRequest().setLogDeliveryConfigurationId(logDeliveryConfigurationId).setStatus(status));
    }

    public void patchStatus(UpdateLogDeliveryConfigurationStatusRequest request) {
        this.impl.patchStatus(request);
    }

    public LogDeliveryService impl() {
        return this.impl;
    }
}

