/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.catalog;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.core.DatabricksException;
import com.databricks.internal.sdk.core.http.Request;
import com.databricks.internal.sdk.service.catalog.AccountMetastoresService;
import com.databricks.internal.sdk.service.catalog.AccountsCreateMetastore;
import com.databricks.internal.sdk.service.catalog.AccountsMetastoreInfo;
import com.databricks.internal.sdk.service.catalog.AccountsUpdateMetastore;
import com.databricks.internal.sdk.service.catalog.DeleteAccountMetastoreRequest;
import com.databricks.internal.sdk.service.catalog.DeleteResponse;
import com.databricks.internal.sdk.service.catalog.GetAccountMetastoreRequest;
import com.databricks.internal.sdk.service.catalog.ListMetastoresResponse;
import com.databricks.internal.sdk.support.Generated;
import java.io.IOException;

@Generated
class AccountMetastoresImpl
implements AccountMetastoresService {
    private final ApiClient apiClient;

    public AccountMetastoresImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public AccountsMetastoreInfo create(AccountsCreateMetastore request) {
        String path = String.format("/api/2.0/accounts/%s/metastores", this.apiClient.configuredAccountID());
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, AccountsMetastoreInfo.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void delete(DeleteAccountMetastoreRequest request) {
        String path = String.format("/api/2.0/accounts/%s/metastores/%s", this.apiClient.configuredAccountID(), request.getMetastoreId());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            this.apiClient.execute(req, DeleteResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public AccountsMetastoreInfo get(GetAccountMetastoreRequest request) {
        String path = String.format("/api/2.0/accounts/%s/metastores/%s", this.apiClient.configuredAccountID(), request.getMetastoreId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, AccountsMetastoreInfo.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListMetastoresResponse list() {
        String path = String.format("/api/2.0/accounts/%s/metastores", this.apiClient.configuredAccountID());
        try {
            Request req = new Request("GET", path);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListMetastoresResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public AccountsMetastoreInfo update(AccountsUpdateMetastore request) {
        String path = String.format("/api/2.0/accounts/%s/metastores/%s", this.apiClient.configuredAccountID(), request.getMetastoreId());
        try {
            Request req = new Request("PUT", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, AccountsMetastoreInfo.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

