/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.catalog;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.core.DatabricksException;
import com.databricks.internal.sdk.core.http.Request;
import com.databricks.internal.sdk.service.catalog.CatalogInfo;
import com.databricks.internal.sdk.service.catalog.CatalogsService;
import com.databricks.internal.sdk.service.catalog.CreateCatalog;
import com.databricks.internal.sdk.service.catalog.DeleteCatalogRequest;
import com.databricks.internal.sdk.service.catalog.DeleteResponse;
import com.databricks.internal.sdk.service.catalog.GetCatalogRequest;
import com.databricks.internal.sdk.service.catalog.ListCatalogsRequest;
import com.databricks.internal.sdk.service.catalog.ListCatalogsResponse;
import com.databricks.internal.sdk.service.catalog.UpdateCatalog;
import com.databricks.internal.sdk.support.Generated;
import java.io.IOException;

@Generated
class CatalogsImpl
implements CatalogsService {
    private final ApiClient apiClient;

    public CatalogsImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public CatalogInfo create(CreateCatalog request) {
        String path = "/api/2.1/unity-catalog/catalogs";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, CatalogInfo.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void delete(DeleteCatalogRequest request) {
        String path = String.format("/api/2.1/unity-catalog/catalogs/%s", request.getName());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            this.apiClient.execute(req, DeleteResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public CatalogInfo get(GetCatalogRequest request) {
        String path = String.format("/api/2.1/unity-catalog/catalogs/%s", request.getName());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, CatalogInfo.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListCatalogsResponse list(ListCatalogsRequest request) {
        String path = "/api/2.1/unity-catalog/catalogs";
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListCatalogsResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public CatalogInfo update(UpdateCatalog request) {
        String path = String.format("/api/2.1/unity-catalog/catalogs/%s", request.getName());
        try {
            Request req = new Request("PATCH", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, CatalogInfo.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

