/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.catalog;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.service.catalog.CancelRefreshRequest;
import com.databricks.internal.sdk.service.catalog.CreateMonitor;
import com.databricks.internal.sdk.service.catalog.DeleteQualityMonitorRequest;
import com.databricks.internal.sdk.service.catalog.GetQualityMonitorRequest;
import com.databricks.internal.sdk.service.catalog.GetRefreshRequest;
import com.databricks.internal.sdk.service.catalog.ListRefreshesRequest;
import com.databricks.internal.sdk.service.catalog.MonitorInfo;
import com.databricks.internal.sdk.service.catalog.MonitorRefreshInfo;
import com.databricks.internal.sdk.service.catalog.MonitorRefreshListResponse;
import com.databricks.internal.sdk.service.catalog.QualityMonitorsImpl;
import com.databricks.internal.sdk.service.catalog.QualityMonitorsService;
import com.databricks.internal.sdk.service.catalog.RegenerateDashboardRequest;
import com.databricks.internal.sdk.service.catalog.RegenerateDashboardResponse;
import com.databricks.internal.sdk.service.catalog.RunRefreshRequest;
import com.databricks.internal.sdk.service.catalog.UpdateMonitor;
import com.databricks.internal.sdk.support.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class QualityMonitorsAPI {
    private static final Logger LOG = LoggerFactory.getLogger(QualityMonitorsAPI.class);
    private final QualityMonitorsService impl;

    public QualityMonitorsAPI(ApiClient apiClient) {
        this.impl = new QualityMonitorsImpl(apiClient);
    }

    public QualityMonitorsAPI(QualityMonitorsService mock) {
        this.impl = mock;
    }

    public void cancelRefresh(String tableName, String refreshId) {
        this.cancelRefresh(new CancelRefreshRequest().setTableName(tableName).setRefreshId(refreshId));
    }

    public void cancelRefresh(CancelRefreshRequest request) {
        this.impl.cancelRefresh(request);
    }

    public MonitorInfo create(String tableName, String assetsDir, String outputSchemaName) {
        return this.create(new CreateMonitor().setTableName(tableName).setAssetsDir(assetsDir).setOutputSchemaName(outputSchemaName));
    }

    public MonitorInfo create(CreateMonitor request) {
        return this.impl.create(request);
    }

    public void delete(String tableName) {
        this.delete(new DeleteQualityMonitorRequest().setTableName(tableName));
    }

    public void delete(DeleteQualityMonitorRequest request) {
        this.impl.delete(request);
    }

    public MonitorInfo get(String tableName) {
        return this.get(new GetQualityMonitorRequest().setTableName(tableName));
    }

    public MonitorInfo get(GetQualityMonitorRequest request) {
        return this.impl.get(request);
    }

    public MonitorRefreshInfo getRefresh(String tableName, String refreshId) {
        return this.getRefresh(new GetRefreshRequest().setTableName(tableName).setRefreshId(refreshId));
    }

    public MonitorRefreshInfo getRefresh(GetRefreshRequest request) {
        return this.impl.getRefresh(request);
    }

    public MonitorRefreshListResponse listRefreshes(String tableName) {
        return this.listRefreshes(new ListRefreshesRequest().setTableName(tableName));
    }

    public MonitorRefreshListResponse listRefreshes(ListRefreshesRequest request) {
        return this.impl.listRefreshes(request);
    }

    public RegenerateDashboardResponse regenerateDashboard(String tableName) {
        return this.regenerateDashboard(new RegenerateDashboardRequest().setTableName(tableName));
    }

    public RegenerateDashboardResponse regenerateDashboard(RegenerateDashboardRequest request) {
        return this.impl.regenerateDashboard(request);
    }

    public MonitorRefreshInfo runRefresh(String tableName) {
        return this.runRefresh(new RunRefreshRequest().setTableName(tableName));
    }

    public MonitorRefreshInfo runRefresh(RunRefreshRequest request) {
        return this.impl.runRefresh(request);
    }

    public MonitorInfo update(String tableName, String outputSchemaName) {
        return this.update(new UpdateMonitor().setTableName(tableName).setOutputSchemaName(outputSchemaName));
    }

    public MonitorInfo update(UpdateMonitor request) {
        return this.impl.update(request);
    }

    public QualityMonitorsService impl() {
        return this.impl;
    }
}

